package com.lwby.marketing;

import com.alicp.jetcache.anno.config.EnableCreateCacheAnnotation;
import com.alicp.jetcache.anno.config.EnableMethodCache;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;
import java.util.*;

@EnableCreateCacheAnnotation
@EnableMethodCache(basePackages = "com.lwby.marketing")
@SpringBootApplication
@RestController
@EnableAsync
@Slf4j
@Component
public class Main {
    private static final Logger DYSTORY_SYS_LOG = LoggerFactory.getLogger("dystory.sys");
    private static final Logger DYSTORY_ERROR_LOG = LoggerFactory.getLogger("dystory.error");
    private static final Logger NOVEL_SYS_LOG = LoggerFactory.getLogger("novel.sys");
    private static final Logger NOVEL_ERROR_LOG = LoggerFactory.getLogger("novel.error");

    @PostConstruct
    public void plog(){
        //只输出到 /data/marketing/logs/dystory_sys.log
        DYSTORY_SYS_LOG.info("DyStory Closing reporter org.apache.kafka.common.metrics.JmxReporter ");
        //只输出到 /data/marketing/logs/dystory_error.log
        DYSTORY_ERROR_LOG.error("DyStory Exception.......");
        //只输出到 /data/marketing/logs/novel_sys.log
        NOVEL_SYS_LOG.info("Novel Closing reporter org.apache.kafka.common.metrics.JmxReporter ");
        //只输出到 /data/marketing/logs/novel_error.log
        NOVEL_ERROR_LOG.error("Novel Exception.......");
        //输出控制台全部内容
        log.info("INFO.........INFO........INFO..");
    }

    public static void main(String[] args) {
        TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
        SpringApplication.run(Main.class, args);
    }
}