package com.lwby.marketing.att.bystory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.lwby.marketing.vo.StoryNovelAction;
import com.lwby.marketing.vo.StoreUserUploadEventBO;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;

/**
 * @author songxinyu
 * @version StoreNovelPayConsumer.java, v 0.1 2024年03月05日 10:40 songxinyu Exp $
 */
@Slf4j
@Component
public class DyStoryPayConsumer extends DyStoryFlowExecutor {

    @Resource
    DyStoryFlowExecutor dyStoryFlowExecutor;

    private static final Logger DYSTORY_SYS_LOG = LoggerFactory.getLogger("dystory.sys");

    private static final Logger DYSTORY_ERROR_LOG = LoggerFactory.getLogger("dystory.error");

    @KafkaListener(topics = {"${system.consumer.dystory.pay.topic}"} ,containerFactory = "kafkaListenerContainerFactoryStorypay")
    public void onMessage(List<ConsumerRecord<String, String>> datas) {

        long begin = System.currentTimeMillis();
        if (DYSTORY_SYS_LOG.isInfoEnabled()) {
            DYSTORY_SYS_LOG.info("media.active.story.onMessage start ,size = {}", datas.size());
        }

        for (ConsumerRecord<String, String> data : datas) {
            try {
                if (data == null) {
                    log.warn("media.pay.story.onMessage listen 消费数据为null");
                    return;
                }
                DYSTORY_SYS_LOG.info("media.pay.story.onMessage start, data={}", data == null ? null : data.value());

                StoreUserUploadEventBO event = JSONObject.parseObject(data.value(), StoreUserUploadEventBO.class);

                DYSTORY_SYS_LOG.info("media.pay.story.topic={}, bookStoreEvent={}", data.topic(), JSON.toJSONString(event));

                StoryNovelAction action = new StoryNovelAction(event.getClientInfo(), event.getUserId(), event.getOpenId(),
                        event.getUserUploadEvent(), event.getProductId());

                dyStoryFlowExecutor.getExecutorByStory().execute(action);
            } catch (Throwable e) {
                DYSTORY_ERROR_LOG.error("story.novel.pay.onMessage failed, data={}, costTime={} ms", data.value(),
                        System.currentTimeMillis() - begin, e);
            }
        }

    }

}
