package com.lwby.marketing.att.bystory;

import com.alibaba.fastjson.JSONObject;
import com.alicp.jetcache.anno.CacheRefresh;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.Cached;
import com.lwby.marketing.att.UniversalProcess;
import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.StoryNovelAction;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;

import java.util.Objects;
@Slf4j
@Component
public class DyStoryUniversalProcess extends UniversalProcess {

    private static final Logger DYSTORY_SYS_LOG   = LoggerFactory.getLogger("dystory.sys");
    private static final Logger DYSTORY_ERROR_LOG = LoggerFactory.getLogger("dystory.error");
    /**
     * 通知处理结果
     */
    public void notifyResult(StoryNovelAction action,String topic, AttributionStatus status) {
        DeliveryDeviceInfo ddi = action.getDeliveryDeviceInfo();

        if (Objects.isNull(ddi)) {
            ddi = new DeliveryDeviceInfo();
            String channelStr = String.valueOf(action.getChannelId());
            ddi.setMedia(MediaMapping.getMediaNameByChannelId(channelStr));
            ddi.setAd_plan_id("0");
            ddi.setAd_group_id("0");
            ddi.setAd_creative_id("0");
            ddi.setPlatform_id(String.valueOf(action.getPlatformId()));
            ddi.setDj_channel(channelStr);
        }

        ddi.setIs_call(status.id);
        ddi.setUserId(action.getUserId());
        ddi.setDevice_id(String.valueOf(action.getUserId()));
        ddi.setActive_time(System.currentTimeMillis());
        ddi.setChannel(String.valueOf(action.getChannelId()));
        ddi.setUserId(action.getUserId());

        String jsonString = JSONObject.toJSONString(ddi);
        ListenableFuture<SendResult<String, String>> active_result = novelKafkaTemplate.send(topic, jsonString);
        active_result.addCallback(
                result -> DYSTORY_SYS_LOG.info("归因成功[{}],归因类型[{}]", jsonString, status.desc),
                ex -> DYSTORY_ERROR_LOG.error("归因失败[{}],归因类型[{}]", jsonString, status.desc, ex)
        );
    }

    public String getTotalCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId,String goodsId ,int sprDedu, String dateStr) {
        return String.format("%s_total_%d_%d_%s_%d_%s", attributionType, platformId, channelOrPlanId,goodsId, sprDedu, dateStr);
    }

    public String getCallbackCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId,String goodsId, int sprDedu, String dateStr) {
        return String.format("%s_callback_%d_%d_%s_%d_%s", attributionType, platformId, channelOrPlanId,goodsId, sprDedu, dateStr);
    }

    public String getFirstCheckerKey(StoryNovelAction action) {
        return Objects.equals(action.getType(),CallBackType.active.getType())
                ? String.format("fc_%d_%d_%s_%s", action.getUserId(), action.getPlatformId(),action.getMediaName(),action.getCurrentDateStr())
                : String.format("fc_%d_%d_%s", action.getUserId(), action.getPlatformId(),action.getMediaName());
    }


    /******************************************** JDBC *************************************************************/

    @Cached(name="attribute_rule_store_novel", cacheType = CacheType.LOCAL)
    @CacheRefresh(refresh = 300)
    public String getAttributeRuleByPlatformIdAndChannelId(int platformId,Long channelId) {
        try {
            return lwbyJdbcTemplate.queryForObject(String.format("select  shave_make_call from attribute_rule where channel_id=%d and platform_id=%d",channelId,platformId),String.class);
        } catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}
