package com.lwby.marketing.att.dyvideo;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alicp.jetcache.anno.CacheRefresh;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.Cached;
import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.UniversalProcess;
import com.lwby.marketing.att.bystory.CallBackType;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.po.ThirdAccountDy;
import com.lwby.marketing.vo.AppChannelVO;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.StoryNovelAction;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Slf4j
@Component
public class DyVideoUniversalProcess extends UniversalProcess {

    private static final Logger DYVIDEO_SYS_LOG = LoggerFactory.getLogger("dyvideo.sys");

    private static final Logger DYVIDEO_ERROR_LOG = LoggerFactory.getLogger("dyvideo.error");

    @Resource
    private RedisTemplate<String,String> oldMarketRedisTemplate;

    /**
     * 通知处理结果
     */
    public void notifyResult(StoryNovelAction action,String topic, AttributionStatus status) {
        DeliveryDeviceInfo ddi = action.getDeliveryDeviceInfo();

        if (Objects.isNull(ddi)) {
            ddi = new DeliveryDeviceInfo();
            String channelStr = String.valueOf(action.getChannelId());
            ddi.setMedia(MediaMapping.getMediaNameByChannelId(channelStr));
            ddi.setAd_plan_id("0");
            ddi.setAd_group_id("0");
            ddi.setAd_creative_id("0");
            ddi.setPlatform_id(String.valueOf(action.getPlatformId()));
            ddi.setDj_channel(channelStr);
        }

        ddi.setIs_call(status.id);
        ddi.setUserId(action.getUserId());
        ddi.setDevice_id(String.valueOf(action.getUserId()));
        ddi.setActive_time(System.currentTimeMillis());
        ddi.setChannel(String.valueOf(action.getChannelId()));
        ddi.setUserId(action.getUserId());

        String jsonString = JSONObject.toJSONString(ddi);
        ListenableFuture<SendResult<String, String>> active_result = novelKafkaTemplate.send(topic, jsonString);
        active_result.addCallback(
                result -> DYVIDEO_SYS_LOG.info("归因成功[{}],归因类型[{}]", jsonString, status.desc),
                ex -> DYVIDEO_ERROR_LOG.error("归因失败[{}],归因类型[{}]", jsonString, status.desc, ex)
        );
    }

    @Override
    public <T> T get(Class<T> clazz, String key) {
        String value = oldMarketRedisTemplate.opsForValue().get(key);
        if(!Objects.isNull(value)){
            return JSON.parseObject(value,clazz);
        }
        return null;
    }

    public void setToken(String key, int expires, String value) {
        oldMarketRedisTemplate.opsForValue().set(key,value,expires, TimeUnit.SECONDS);
    }

    public void delToken(String key) {
        oldMarketRedisTemplate.delete(key);
    }



    public String getTotalCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId ,int sprDedu, String dateStr) {
        return String.format("%s_total_%d_%d_%d_%s", attributionType, platformId, channelOrPlanId, sprDedu, dateStr);
    }

    public String getCallbackCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId, int sprDedu, String dateStr) {
        return String.format("%s_callback_%d_%d_%d_%s", attributionType, platformId, channelOrPlanId, sprDedu, dateStr);
    }

    public String getFirstCheckerKey(StoryNovelAction action) {
        return Objects.equals(action.getType(), CallBackType.active.getType())
                ? String.format("fc_%d_%d_%s_%s", action.getUserId(), action.getPlatformId(),action.getMediaName(),action.getCurrentDateStr())
                : String.format("fc_%d_%d_%s", action.getUserId(), action.getPlatformId(),action.getMediaName());
    }

    public int getExpire(StoryNovelAction action) {
        return Objects.equals(action.getType(), CallBackType.active.getType())
                ? 60 * 60 * 24
                : 60 * 60 * 24 * 7;
    }

    public ThirdAccountDy getDyAccessToken(String client_id, String client_secret,String dyTokenUrl) {
        Map<String,String> upMap = new HashMap<>();
        upMap.put("client_key",client_id);
        upMap.put("client_secret",client_secret);
        upMap.put("grant_type","client_credential");
        String mapAction = JSONObject.toJSONString(upMap);
        ThirdAccountDy thirdAccountDy = null;
        try {
            String result = HttpUtil.post(dyTokenUrl, mapAction);
            Map data = (Map) JSON.parseObject(result).get("data");
            Integer resultCode = (Integer) data.get("error_code");
            String accessToken = "";
            if (resultCode == 0) {
                //成功
                accessToken = (String) data.get("access_token");
                Integer expiresIn = (Integer) data.get("expires_in");
                thirdAccountDy = new ThirdAccountDy();
                thirdAccountDy.setAccessToken(accessToken);
                thirdAccountDy.setExpireIn(expiresIn);
                thirdAccountDy.setClientId(client_id);
                String tokenDy = "token_dy_" + client_id;
                //往老的market缓存写，防止token一直失效
                setToken(tokenDy, Integer.parseInt(String.valueOf(expiresIn)),JSON.toJSONString(thirdAccountDy));
            } else {
                log.warn("dy_access_token_error,code={},resultdy={}", resultCode, JSONObject.toJSONString(result));
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }

        return thirdAccountDy;
    }


    /******************************************** JDBC *************************************************************/

    @Cached(name="appchannel_dy_video", cacheType = CacheType.LOCAL)
    @CacheRefresh(refresh = 300)
    public AppChannelVO getAppChannelByPlatformAndChannel(int platformId,Long channelId) {
        try {
            RowMapper<AppChannelVO> rowMapper = BeanPropertyRowMapper.newInstance(AppChannelVO.class);

            return videoJdbcTemplate.queryForObject(String.format("select id,ecpm_avg_count,motivation_count,ecpm_per_count,spr_dedu "
                    + "from app_channel where channel_id=%d and platform_id=%d",channelId,platformId),rowMapper);
        } catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}
