package com.lwby.marketing.att.novel;

import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.UniversalProcess;
import com.lwby.marketing.vo.NovelAction;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;

import java.util.Objects;

@Slf4j
@Component
public class NovelUniversalProcess extends UniversalProcess {
    public static final  String PRIZE_FLOW_PREFIX = "c:ouser:";
    private static final Logger NOVEL_SYS_LOG     = LoggerFactory.getLogger("novel.sys");
    private static final Logger NOVEL_ERROR_LOG = LoggerFactory.getLogger("novel.error");

    /**
     * 通知处理结果
     */
    public void notifyResult(NovelAction action, AttributionStatus status) {
        DeliveryDeviceInfo ddi = action.getDeliveryDeviceInfo();

        if (Objects.isNull(ddi)) {
            ddi = new DeliveryDeviceInfo();
            String channelStr = String.valueOf(action.getClientInfo().getChannel());
            ddi.setMedia(MediaMapping.getMediaNameByChannelId(channelStr));
            ddi.setAd_plan_id("0");
            ddi.setAd_group_id("0");
            ddi.setAd_creative_id("0");
            ddi.setPlatform_id(String.valueOf(action.getPlatformId()));
            ddi.setDj_channel(channelStr);
        }

        ddi.setOs(action.getClientInfo().getOs());
        ddi.setIs_call(status.id);
        ddi.setDevice_id(action.getDeviceId());
        ddi.setActive_time(System.currentTimeMillis());
        ddi.setChannel(String.valueOf(action.getChannelId()));
        ddi.setUserId(action.getUserId());
        ddi.setDevice_status(exists(PRIZE_FLOW_PREFIX.concat(String.valueOf(ddi.getUserId()))) ? 2 : 0);

        String jsonString = JSONObject.toJSONString(ddi);
        ListenableFuture<SendResult<String, String>> active_result = novelKafkaTemplate.send("ocpc_result_test", jsonString);
        active_result.addCallback(
                result -> NOVEL_SYS_LOG.info("归因成功[{}],归因类型[{}]", jsonString, status.desc),
                ex -> NOVEL_ERROR_LOG.error("归因失败[{}],归因类型[{}]", jsonString, status.desc, ex)
        );
    }

    /******************************************** ASSEMBLE KEY ***************************************************/

    public String getTotalCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId, int sprDedu, String dateStr) {
        return String.format("%s_total_%d_%d_%d_%s", attributionType, platformId, channelOrPlanId, sprDedu, dateStr);
    }

    public String getCallbackCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId, int sprDedu, String dateStr) {
        return String.format("%s_callback_%d_%d_%d_%s", attributionType, platformId, channelOrPlanId, sprDedu, dateStr);
    }

    public String getFirstCheckerKey(NovelAction action) {
        return String.format("fc_%s_%d_%s_%s", action.getDeviceId(), action.getPlatformId(),action.getMediaName(),action.getCurrentDateStr());
    }

    public String buildKey(Integer platformId,String deviceId) {
        return String.format("market:activeness:30:%d:%s",platformId,deviceId);
    }
}