package com.lwby.marketing.att.novel.handle;

import com.alicp.jetcache.anno.CacheRefresh;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.Cached;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.vo.NovelAction;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component("novel_plan")
public class PlanAttributionFlow extends ChannelAttributionFlow {
    @Resource
    JdbcTemplate lwbyJdbcTemplate;

    @Override
    public boolean checked(NovelAction action) {
        //如果投放帐号没有配置计划归因，继续执行下一个渠道归因处理器
        return getPlanAccount().contains(action.getAdvertiserId());
    }

    @Override
    public void process(NovelAction action) {
        process0(action, AttributionType.PLAN);
    }

    @Cached(name="plan_account", cacheType = CacheType.LOCAL)
    @CacheRefresh(refresh = 300)
    public Set<String> getPlanAccount(){
        List<String> ls = lwbyJdbcTemplate.queryForList("select account from account_plan_callback",String.class);

        return ls.stream()
                 .flatMap(e -> Arrays.stream(e.split(",")))
                 .map(String::trim)
                 .filter(_s -> _s.matches("\\d+"))
                 .collect(Collectors.toSet());
    }
}