package com.lwby.marketing.att.novel.handle;

import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.novel.DeviceType;
import com.lwby.marketing.att.novel.NovelUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.vo.NovelAction;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

@Component("novel_store")
public class StoreAttributionFlow extends NodeFlow<NovelAction> {
    @Resource
    NovelUniversalProcess up;

    @Override
    public void process(NovelAction action) {
        //商店归因通知
        if(Objects.isNull(action.getDeliveryDeviceInfo())){
            //商店判断30天活跃，不在活跃天数内，发BI
            String aliveDeviceKey = up.buildKey(action.getPlatformId(), action.getDeviceId());
            if (!up.existsIsAlive(aliveDeviceKey)) {
                up.notifyResult(action, AttributionStatus.STORE_CALLBACK);
            }
            action.stop(true);   //结束后面所有执行流程
        }

        //IP归因通知
        if(DeviceType.IP == action.getDeviceType()){
            up.notifyResult(action,AttributionStatus.IP_CALLBACK);
            action.stop(true);   //结束后面所有执行流程
        }
    }
}