package com.lwby.marketing.att.videoapp;

import com.lwby.marketing.vo.ClientInfo;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DeviceVideoType {
    IMEI("imei",(c) -> isNotEmptyAndSNull(c.getImei())?c.getImei():null),
    OAID("oaid", (c) -> isNotEmptyAndSNull(c.getOaid())?c.getOaid():null),
    IDFA("idfa",(c) -> isNotEmptyAndSNull(c.getIdfa())?c.getIdfa():null),
    IP_UA("ipua",(c) ->
            (isNotEmptyAndSNull(c.getClientIp()) && isNotEmptyAndSNull(c.getUa())) ?
                    (("0".equals(c.getOs()) ? c.getClientIp().concat(StringUtils.substringBefore(c.getUa(), " Chrome/")) :
                            ( c.getUa().startsWith("bi kan duan ju") ? Arrays.stream(c.getSystemVersion().split("\\.")).collect(Collectors.joining("_")):
                                    c.getClientIp().concat(c.getUa())))):null),
    IP_MODEL("ipmodel",(c) -> isNotEmptyAndSNull(c.getClientIp()) && isNotEmptyAndSNull(c.getPhoneModel())?c.getClientIp().concat(c.getPhoneModel()):null);

    private String value;

    private Function<ClientInfo,String> fun;

    DeviceVideoType(String value, Function<ClientInfo,String> fun) {
        this.value = value;
        this.fun = fun;
    }

    public String getValue() {
        return this.value;
    }

    public String getDeviceId(ClientInfo clientInfo){
        return fun.apply(clientInfo);
    }

    private static boolean isNotEmptyAndSNull(String str) {
        return StringUtils.isNotEmpty(str) && !"null".equals(str);
    }
}