package com.lwby.marketing.att.videoapp.handle;

import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.bystory.CallBackType;
import com.lwby.marketing.att.videoapp.VideoAppUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.vo.NovelAction;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

@Component("videoapp_store")
public class StoreVideoAppAttributionFlow extends NodeFlow<NovelAction> {
    @Resource
    VideoAppUniversalProcess up;

    @Override
    public void process(NovelAction action) {
        //商店归因通知
        if(Objects.isNull(action.getDeliveryDeviceInfo())){
            if (action.getType().equals(CallBackType.active.getType())) {
                //商店判断30天活跃，不在活跃天数内，发BI
                String aliveDeviceKey = up.buildKey(action.getPlatformId(), action.getDeviceId());
                if (!up.existsIsAlive(aliveDeviceKey)) {
                    up.notifyResult(action,"ocpc_result_test", AttributionStatus.STORE_CALLBACK);
                }
            }
            action.stop(true);   //结束后面所有执行流程
        }

    }
}