package com.lwby.marketing.att.bystory.handle;

import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.att.bystory.CallBackType;
import com.lwby.marketing.att.bystory.DyStoryUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.notify.Media;
import com.lwby.marketing.notify.media.Platform;
import com.lwby.marketing.po.StoryLogin;
import com.lwby.marketing.util.DateTimUtils;
import com.lwby.marketing.util.NumberUtils;
import com.lwby.marketing.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.UUID;

@Slf4j
@Component("dystory_setup")
public class ParameterSetupStoryNovelFlow extends NodeFlow<StoryNovelAction> {
    @Resource
    DyStoryUniversalProcess up;

    @Override
    public void process(StoryNovelAction action) {
        ClientInfo clientInfo = action.getClientInfo();
        String openId = action.getOpenId();

        //平台ID
        Integer platformId = clientInfo.getPlatformId();
        //VO对像
        DeliveryDeviceInfo deliveryDeviceInfo = null;

        //String s = "{\"creativeId\":\"112331\",\"creativeType\":\"3\",\"adid\":\"12321\","
        //        + "\"clickId\":\"12312143232\",\"channel\":\"216011231\",\"bookId\":\"4322111\","
        //        + "\"media\":\"jrtt\",\"clickTime\":123123123,\"code\":\"12ede3e231\"}";;
        //StoryLogin storyLogin = JSONObject.parseObject(s,StoryLogin.class);
        //匹配OpenId
        StoryLogin storyLogin = up.get(StoryLogin.class,assembleKey(openId));
        action.setStoryLogin(storyLogin);

        //StoryNovelAction对像参数填充
        action.setPlatformId(platformId);
        action.setUserId(action.getUserId());
        action.setCurrentDateStr(DateTimUtils.getCurrentDateString());

        if (CallBackType.active.getType().equals(action.getType())) {
            action.setChannelId((long)action.getClientInfo().getChannel());
        }


        //非商店吊起参数设置
        if (Objects.nonNull(storyLogin)) {
            deliveryDeviceInfo = new DeliveryDeviceInfo();
            deliveryDeviceInfo.setAd_creative_id(storyLogin.getCreativeId());
            deliveryDeviceInfo.setPlatform_id(String.valueOf(clientInfo.getPlatformId()));
            deliveryDeviceInfo.setCallback_param(storyLogin.getClickId());
            deliveryDeviceInfo.setUuid(UUID.randomUUID().toString());
            deliveryDeviceInfo.setDj_channel(storyLogin.getChannel());
            deliveryDeviceInfo.setPromotion_id(storyLogin.getAdid());
            deliveryDeviceInfo.setBook_id(storyLogin.getBookId());
            action.setDeliveryDeviceInfo(deliveryDeviceInfo);
            action.setChannelId(NumberUtils.parseLong(storyLogin.getChannel()));
            action.setPlanId(NumberUtils.parseLong((storyLogin.getAdid())));
            action.setMediaName(storyLogin.getMedia());
            action.setMedia(Media.getMedia(action.getMediaName(), Platform.DY_STORY));
        }
    }

    public String assembleKey(String openId) {
        return String.format("story:upload:%s", openId);
    }
}
