package com.lwby.marketing.att.bystory.handle;

import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.bystory.CallBackType;
import com.lwby.marketing.att.bystory.DyStoryUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.vo.StoryNovelAction;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

@Component("dystory_store")
public class StoreDyStoryAttributionFlow extends NodeFlow<StoryNovelAction> {
    @Resource
    DyStoryUniversalProcess up;

    @Override
    public void process(StoryNovelAction action) {
        //商店归因通知
        if(Objects.isNull(action.getDeliveryDeviceInfo())){
            if (action.getType().equals(CallBackType.active.getType())) {
                up.notifyResult(action,"ocpc_result", AttributionStatus.STORE_CALLBACK);
            }
            action.stop(true);   //结束后面所有执行流程
        }

    }
}