package com.lwby.marketing.att.bystory.handle;

import com.lwby.marketing.att.bystory.CallBackType;
import com.lwby.marketing.att.bystory.DyStoryUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.vo.StoryNovelAction;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author songxinyu
 * @version ActiveCallFlow.java, v 0.1 2024年03月04日 18:28 songxinyu Exp $
 */
@Component("dystory_uploadcall")
public class UploadCallFlow extends NodeFlow<StoryNovelAction> {

    @Resource
    DyStoryUniversalProcess up;

    @Override
    public void process(StoryNovelAction action) {
        CallBackType type = CallBackType.getCallBackTypeByType(action.getType());

        boolean success = action.getMedia().notify(action);
        if (success) {
            up.notifyResult(action, type.getTopic(),type.getStatus());
            up.set(up.getFirstCheckerKey(action),60 * 60 * 24,"1");
        }
    }
}
