package com.lwby.marketing.att.dyvideo.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.bystory.CallBackType;
import com.lwby.marketing.att.dyvideo.DyVideoUniversalProcess;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.flow.NodeSwitchFlow;
import com.lwby.marketing.po.ThirdAccountDy;
import com.lwby.marketing.po.VideoUpload;
import com.lwby.marketing.util.CacheKeyUtils;
import com.lwby.marketing.util.HttpUtil;
import com.lwby.marketing.vo.AppChannelVO;
import com.lwby.marketing.vo.StoryNovelAction;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.*;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

/**
 * @author songxinyu
 * @version PaySpduFlow.java, v 0.1 2024年03月04日 18:46 songxinyu Exp $
 */
@Slf4j
@Component("dyvideo_behavior")
public class DyvideoBehaviorFlow extends NodeSwitchFlow<StoryNovelAction> {

    private static final Logger DYVIDEO_SYS_LOG   = LoggerFactory.getLogger("dyvideo.sys");

    @Resource
    DyVideoUniversalProcess up;

    @Autowired
    private Environment env;

    private static final String tokenDyDevUrl = "https://open-sandbox.douyin.com/oauth/client_token/";

    private static final String tokenDyProdUrl = "https://open.douyin.com/oauth/client_token/";

    SimpleDateFormat dfh = new SimpleDateFormat("yyyy-MM-dd");//设置日期格式

    private static final String url = "https://open.douyin.com/api/traffic/v1/rt_ecpm/query/";


    @Override
    public boolean checked(StoryNovelAction action) {
        return action.getType() == 3;
    }

    @Override
    @Async("commonTaskExecutor")
    public void process(StoryNovelAction action) {
        VideoUpload videoUpload = action.getVideoUpload();
        long userId = action.getUserId();

        long activeTime = videoUpload.getActiveTime();
        long currentTime = System.currentTimeMillis();
        long hour = TimeUnit.MILLISECONDS.toHours(currentTime - activeTime);
        if (hour > 6) {
            DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow expeed six hour ,videoUpload={},userId={}",JSON.toJSONString(videoUpload),userId);
            //action.stop(true);
            return;
        }
        int platformId = action.getPlatformId();
        Long channelId = action.getChannelId();
        AppChannelVO appChannel = up.getAppChannelByPlatformAndChannel(platformId,channelId);

        //处理关键行为上报
        Integer ecpmAvgModelCount = null ;
        Integer pecpmModelCount = null;
        Integer motivateModelCount = null ;
        String media = action.getMediaName();
        String openId = action.getOpenId();

        if (Objects.nonNull(appChannel) && ((Objects.nonNull(appChannel.getEcpmAvgCount()) && Objects.nonNull(appChannel.getMotivationCount()))
                || (Objects.nonNull(appChannel.getEcpmPerCount()) && Objects.nonNull(appChannel.getMotivationCount())))) {
            if (Objects.nonNull(appChannel.getEcpmAvgCount()) && Objects.nonNull(appChannel.getMotivationCount())) {
                ecpmAvgModelCount = appChannel.getEcpmAvgCount().intValue();
                motivateModelCount = appChannel.getMotivationCount().intValue();
            }
            if (Objects.nonNull(appChannel.getEcpmPerCount()) && Objects.nonNull(appChannel.getMotivationCount())) {
                pecpmModelCount = appChannel.getEcpmPerCount().intValue();
                motivateModelCount = appChannel.getMotivationCount().intValue();
            }
            DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow.cacheModel in table is set value,djChanel={},userId={},ecpmAvgModelCount={},pecpmModelCount={},motivateModelCount={}",channelId,userId,ecpmAvgModelCount,pecpmModelCount,motivateModelCount);
        } else {
            DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow.cacheModel in table is not set value,djChanel={},userId={}",channelId,userId);
            //action.stop(true);
            return;
        }

        JSONObject dyMarketPlatformAppIdJson = JSON.parseObject(
                "{\n"
                        + "    \"400\": \"ttf2f6844b6dc9702901_d4ac08a22f80f73256836fdd9655dbb0b6e6de7c\",\n"
                        + "    \"412\": \"ttd3dda5604ce230b401_5aac82a8c76db9c54f187dea7b43b58b233459db\"\n"
                        + "}");
        String platformKey = String.valueOf(platformId);
        //走平台
        String dyMarketPlatformAppId = dyMarketPlatformAppIdJson.getString(platformKey);
        List<String> dyMarketPlatformAppIdList = new ArrayList<>();
        if (dyMarketPlatformAppId != null) {

            dyMarketPlatformAppIdList = Arrays.asList(dyMarketPlatformAppId.split("_"));
            String tokenDy = "token_dy_" + dyMarketPlatformAppIdList.get(0);
            ThirdAccountDy thirdAccountDy = null;
            DYVIDEO_SYS_LOG.info("thirdAccountDy url={}",Objects.equals(env.getActiveProfiles()[0],"prod") ? tokenDyProdUrl : tokenDyDevUrl);
            if (up.existsOld(tokenDy)) {
                thirdAccountDy = up.get(ThirdAccountDy.class, tokenDy);
            } else {
                thirdAccountDy = up.getDyAccessToken(dyMarketPlatformAppIdList.get(0), dyMarketPlatformAppIdList.get(1),
                        Objects.equals(env.getActiveProfiles()[0],"prod") ? tokenDyProdUrl : tokenDyDevUrl);
            }
            if (thirdAccountDy != null) {
                //平均ecpm次数
                Integer ecpmAvgCount = null;
                //每次ecpm次数
                Integer pecpmCount = null;
                //激励视频次数
                Integer motivateCount = null;
                //激励视频总ecpm次数
                Integer tvcCount = null;

                LocalDateTime now = LocalDateTime.now(); // 获取当前日期时间
                LocalTime six = LocalTime.of(6, 0, 0); // 获取当天6点的时间
                String accessToken = thirdAccountDy.getAccessToken();

                Date date = new Date();
                Map<String, Integer> resultCountMap = null;
                if (now.toLocalTime().isBefore(six)) {
                    //当天6点之前，查两天,先查昨天的ecpm指标
                    Calendar calendar = Calendar.getInstance(); // 获取日历对象
                    calendar.setTime(date); // 设置时间
                    calendar.add(Calendar.DAY_OF_MONTH, -1); // 将时间减去一天
                    Date day = calendar.getTime();
                    resultCountMap = getResultCountList(day, openId, accessToken, tvcCount, motivateCount, pecpmCount,
                            pecpmModelCount, userId, tokenDy, dyMarketPlatformAppIdList);
                    if (resultCountMap != null && resultCountMap.size() != 0) {
                        tvcCount = resultCountMap.get("tvc");
                        if (tvcCount != null) {
                            tvcCount = tvcCount / 100;
                        }
                        motivateCount = resultCountMap.get("motivate");
                        pecpmCount = resultCountMap.get("pecpm");
                    }
                }
                //查询今天的ecpm指标
                resultCountMap = getResultCountList(date, openId, accessToken, tvcCount, motivateCount, pecpmCount,
                        pecpmModelCount, userId, tokenDy, dyMarketPlatformAppIdList);
                if (resultCountMap != null && resultCountMap.size() != 0) {
                    tvcCount = resultCountMap.get("tvc");
                    if (tvcCount != null) {
                        tvcCount = tvcCount / 100;
                    }
                    motivateCount = resultCountMap.get("motivate");
                    pecpmCount = resultCountMap.get("pecpm");
                }

                if (Objects.nonNull(tvcCount) && Objects.nonNull(motivateCount)) {
                    if (Objects.nonNull(pecpmCount)) {
                        DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow pecpmcount not null,tvcCount={},motivateCount={},pecpmCount={},djChanel={},userId={}", tvcCount,
                                motivateCount, pecpmCount, channelId, userId);
                    }
                    Double ecpmAvgCountD = (double) tvcCount / motivateCount;
                    ecpmAvgCount = ecpmAvgCountD.intValue();
                    DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow.ecpm success,tvcCount={},motivateCount={},djChanel={},userId={}", tvcCount, motivateCount, channelId,
                            userId);
                } else {
                    if (Objects.nonNull(pecpmCount) && Objects.nonNull(motivateCount)) {
                        DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow pempcount and motivate not null,tvcCount={},motivateCount={},pecpmCount={},djChanel={},userId={}",
                                tvcCount, motivateCount, pecpmCount, channelId, userId);
                    } else {
                        DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow tvcandmo not up to the standard,tvcCount={},motivateCount={},djChanel={},userId={}", tvcCount,
                                motivateCount, channelId, userId);
                        //action.stop(true);
                        return;
                    }
                }

                if (Objects.nonNull(motivateModelCount) && Objects.nonNull(motivateCount)) {
                    if (motivateCount < motivateModelCount) {
                        DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow motivate not up to the standard,motivateCount={},motivateModelCount={},djChanel={},userId={}",
                                motivateCount, motivateModelCount, channelId, userId);
                        //action.stop(true);
                        return;
                    }
                    videoUpload.setMotivateCount(String.valueOf(motivateCount));
                }

                if (Objects.nonNull(ecpmAvgModelCount) && Objects.nonNull(ecpmAvgCount)) {
                    if ((ecpmAvgCount < ecpmAvgModelCount)) {
                        DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow ecpm not up to the standard,ecpmAvgCount={},ecpmAvgModelCount={},djChanel={},userId={}",
                                ecpmAvgCount, ecpmAvgModelCount, channelId, userId);
                        //action.stop(true);
                        return;
                    }
                    videoUpload.setEcpmAvgCount(String.valueOf(ecpmAvgCount));
                }

                if (Objects.nonNull(pecpmModelCount) && Objects.nonNull(motivateModelCount) && Objects.nonNull(motivateCount)) {
                    if (Objects.nonNull(pecpmCount)) {
                        if (pecpmCount < motivateModelCount) {
                            DYVIDEO_SYS_LOG.info(
                                    "DyvideoBehaviorFlow pecpmCount not up to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},userId={}",
                                    pecpmModelCount, pecpmCount, motivateModelCount, motivateCount, channelId, userId);
                            //action.stop(true);
                            return;
                        }
                        videoUpload.setPecpmCount(String.valueOf(pecpmModelCount));
                        videoUpload.setPerecpmSize(String.valueOf(pecpmCount));
                        DYVIDEO_SYS_LOG.info(
                                "DyvideoBehaviorFlow pecpmCount up to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},userId={}",
                                pecpmModelCount, pecpmCount, motivateModelCount, motivateCount, channelId, userId);
                    } else {
                        DYVIDEO_SYS_LOG.info(
                                "DyvideoBehaviorFlow pecpmCount is null not to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},userId={}",
                                pecpmModelCount, pecpmCount, motivateModelCount, motivateCount, channelId, userId);
                        //action.stop(true);
                        return;
                    }
                }

                //满足之后扣量
                Integer sprDedu = appChannel.getSprDedu();

                CallBackType type = CallBackType.getCallBackTypeByType(action.getType());
                //等于空 或 100直接回传
                if (sprDedu == null || sprDedu == 100) {
                    action.getMedia().notify(action);
                    up.notifyResult(action, type.getTopic()+"_test",type.getStatus());
                    up.set(up.getFirstCheckerKey(action),up.getExpire(action),"1");
                    return;
                }

                //总数
                String channelTotal =  up.getTotalCountKey(AttributionType.CHANNEL, action.getPlatformId(), action.getChannelId(), sprDedu, action.getCurrentDateStr());
                //回传
                String channelCallback = up.getCallbackCountKey(AttributionType.CHANNEL, action.getPlatformId(), action.getChannelId(), sprDedu, action.getCurrentDateStr());

                long channelTotalCount = up.incrby(channelTotal, 0, 60 * 60 * 24);
                long channelCallbackCount = up.incrby(channelCallback, 0, 60 * 60 * 24);

                up.incrby(channelTotal, 1);

                if (isCallback(channelTotalCount, channelCallbackCount, sprDedu)) {
                    //回传，回传个数 + 1
                    up.incrby(channelCallback, 1);
                    action.getMedia().notify(action);
                    up.notifyResult(action, type.getTopic()+"_test",type.getStatus());
                    up.set(up.getFirstCheckerKey(action),up.getExpire(action),"1");
                    DYVIDEO_SYS_LOG.info(
                            "ChannelAttributionFlow.process0.deduction doing dynamic, platformId = {}, channel = {}, planId={}, sprDedu = {}, channelTotalCount = {}, channelCallbackCount = {}, v = {}",
                            action.getPlatformId(), action.getChannelId(),action.getPlanId(), sprDedu, channelTotalCount, channelCallbackCount, 1);
                } else {
                    up.notifyResult(action,"ocpc_behavior_test", AttributionStatus.NORMAL_DEDUCTION_CALLBACK);
                    up.set(up.getFirstCheckerKey(action), up.getExpire(action), "1");
                    DYVIDEO_SYS_LOG.info(
                            "ChannelAttributionFlow.process0.deduction doing dynamic, platformId = {}, channel = {}, planId={}, sprDedu = {}, channelTotalCount = {}, channelCallbackCount = {}, v = {}",
                            action.getPlatformId(), action.getChannelId(),action.getPlanId(), sprDedu, channelTotalCount, channelCallbackCount, 0);
                }
                //action.stop(true);
            } else {
                //action.stop(true);
            }
        } else {
            //action.stop(true);
        }
    }

    public Map<String,Integer> getResultCountList(Date day,String openid,String accessToken,Integer tvcCount,Integer motivateCount,Integer pecpmCount,Integer pecpmModelCount,Long userId,String tokenDy,List<String> dyMarketPlatformAppIdList) {
        int pageNumer = 1;
        Map<String,Integer> resultCountMap = new HashMap<>();
        String upcBehaviorKey = CacheKeyUtils.getVideoBehavoirKey(userId);

        String cursor = null;

        for (int i=1 ; i<= pageNumer ; i++) {

            Map<String,Object> mp = new HashMap<>();
            mp.put("open_id",openid);
            mp.put("date_hour",dfh.format(day));
            if (cursor != null) {
                mp.put("cursor",cursor);
            }
            String mapAction = JSONObject.toJSONString(mp);
            try {
                String result = HttpUtil.postDy(url, mapAction,accessToken);
                Integer resultCode = (Integer) JSON.parseObject(result).get("err_no");
                if (resultCode == 0) {
                    Map dataMap = (Map) JSON.parseObject(result).get("data");
                    List<JSONObject> records = (List<JSONObject>)dataMap.get("records");
                    String next_cursor = (String)dataMap.get("next_cursor");
                    if (records != null && records.size()>0) {
                        if (Objects.isNull(tvcCount)) {
                            tvcCount = 0;
                        }
                        if (Objects.isNull(motivateCount)) {
                            motivateCount = 0;
                        }
                        if (Objects.isNull(pecpmCount)) {
                            pecpmCount = 0;
                        }
                        motivateCount += records.size();

                        for(JSONObject jsonObject : records) {
                            String cost = jsonObject.getString("cost");
                            Integer costI = Integer.parseInt(cost);
                            Double c =  (double)(costI / 100);
                            int ct = c.intValue();

                            if (pecpmModelCount != null) {
                                if (ct>=pecpmModelCount) {
                                    pecpmCount ++;
                                }
                            }
                            tvcCount +=  costI;

                        }
                        up.hsetNew(upcBehaviorKey,"tvc",60 * 60 * 24 * 3,JSON.toJSONString(tvcCount));
                        up.hsetNew(upcBehaviorKey,"mvc",60 * 60 * 24 * 3,JSON.toJSONString(motivateCount));
                        up.hsetNew(upcBehaviorKey,"vec",60 * 60 * 24 * 3,JSON.toJSONString(pecpmCount));

                    }

                    DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow.douyin code succ,userId={},result={}",userId,JSON.toJSONString(result));
                    if (records != null && records.size() == 500) {
                        pageNumer ++;
                        cursor = next_cursor;
                    }
                } else {
                    DYVIDEO_SYS_LOG.info("DouyinBehaviorKafkaConsumer.douyin code error,userId={},result={}",userId,JSON.toJSONString(result));
                    if (resultCode == 28001008) {
                        //删除授权过期token
                        up.delToken(tokenDy);
                        up.getDyAccessToken(dyMarketPlatformAppIdList.get(0), dyMarketPlatformAppIdList.get(1), Objects.equals(env.getActiveProfiles()[0],"prod") ? tokenDyProdUrl : tokenDyDevUrl);
                        DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow.douyin code auth token expired,userId={},result={}",userId,JSON.toJSONString(result));
                    }
                    return null;
                }
                resultCountMap.put("tvc",tvcCount);
                resultCountMap.put("motivate",motivateCount);
                resultCountMap.put("pecpm",pecpmCount);
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return resultCountMap;
    }

    private boolean isCallback(long channelTotalCount, long channelCallbackCount, Integer sprDedu) {
        if (channelTotalCount == 0) {
            //首次随机
            return ThreadLocalRandom.current().nextInt(1, 3) == 1;
        }
        //计算回传率
        BigDecimal divide = new BigDecimal(channelCallbackCount).divide(new BigDecimal(channelTotalCount), 4, RoundingMode.HALF_UP);
        //比较回传率和扣量比例，决定是否回传
        double percent = (double) Math.round(sprDedu * 100 / 100.0) / 100;
        return divide.compareTo(BigDecimal.valueOf(percent).setScale(4, RoundingMode.HALF_UP)) != 1;
    }
}
