package com.lwby.marketing.att.novel.handle;

import cn.hutool.crypto.SecureUtil;
import com.lwby.marketing.att.novel.DeviceType;
import com.lwby.marketing.att.novel.NovelUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.notify.Media;
import com.lwby.marketing.notify.media.Platform;
import com.lwby.marketing.util.DateTimUtils;
import com.lwby.marketing.util.NumberUtils;
import com.lwby.marketing.vo.NovelAction;
import com.lwby.marketing.vo.ClientInfo;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.UserProfile;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

@Slf4j
@Component("novel_setup")
public class ParameterSetupFlow extends NodeFlow<NovelAction> {
    @Resource
    NovelUniversalProcess up;
    private static final Logger NOVEL_ERROR_LOG = LoggerFactory.getLogger("novel.error");

    @Override
    public void process(NovelAction action) {
        ClientInfo clientInfo = action.getClientInfo();
        //获取用户注册时间
        UserProfile userProfile = clientInfo.getUser();
        if (userProfile == null || userProfile.getRegistrationDate() == null) {
            NOVEL_ERROR_LOG.error("ClientInfo.userProfile 对像为[{}],BookStoreEvent报文[{}]、ClientInfo对像[{}]",userProfile, action.getBody(), clientInfo);
            action.stop(true);
            return;
        }

        //平台ID
        Integer platformId = clientInfo.getPlatformId();
        //设备ID
        String deviceIdKey = null;
        //VO对像
        DeliveryDeviceInfo deliveryDeviceInfo = null;

        //匹配设备ID
        for(DeviceType type:DeviceType.values()){
            deviceIdKey = type.getDeviceId(clientInfo);
            if(null != deviceIdKey && null != (deliveryDeviceInfo = up.get(DeliveryDeviceInfo.class,assembleKey(deviceIdKey,platformId,type)))){
                clientInfo.setOaid(deliveryDeviceInfo.getOaid());   //回补OAID
                action.setDeliveryDeviceInfo(deliveryDeviceInfo);
                action.setDeviceType(type);
                break;
            }
        }

        //NovelAction对像参数填充
        action.setPlatformId(clientInfo.getPlatformId());
        action.setUserId(clientInfo.getUser().getId());
        action.setDeviceId(clientInfo.getDID());
        action.setNewUser(DateTimUtils.isCurrentDayTime(clientInfo.getUser().getRegistrationDate()));
        action.setCurrentDateStr(DateTimUtils.getCurrentDateString());
        action.setRegistrationDate(clientInfo.getUser().getRegistrationDate());
        action.setChannelId((long)clientInfo.getChannel());

        //非商店吊起参数设置
        if (Objects.nonNull(deliveryDeviceInfo)) {
            action.setChannelId(NumberUtils.parseLong(deliveryDeviceInfo.getDj_channel()));
            action.setPlanId(NumberUtils.parseLong((deliveryDeviceInfo.getAd_plan_id())));
            action.setAdvertiserId(deliveryDeviceInfo.getAdvertiser_id());
            action.setMediaName(deliveryDeviceInfo.getMedia());
            action.setMedia(Media.getMedia(action.getMediaName(), Platform.NOVEL));
        }
    }

    public String assembleKey(String deviceId, int platformId,DeviceType type) {
        if (DeviceType.IP == type) {
            return String.format("mck:%s:%d", SecureUtil.md5(deviceId), platformId);
        }
        return String.format("getClickByIdfaAndPlatformId_%s_%d", SecureUtil.md5(deviceId), platformId);
    }
}
