package com.lwby.marketing.att.videoapp;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alicp.jetcache.anno.CacheRefresh;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.Cached;
import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.UniversalProcess;
import com.lwby.marketing.att.bystory.CallBackType;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Slf4j
@Component
public class VideoAppUniversalProcess extends UniversalProcess {

    private static final Logger VIDEOAPP_SYS_LOG = LoggerFactory.getLogger("videoapp.sys");

    private static final Logger VIDEOAPP_ERROR_LOG = LoggerFactory.getLogger("videoapp.error");

    @Resource
    private RedisTemplate<String,String> oldMarketRedisTemplate;

    /**
     * 通知处理结果
     */
    public void notifyResult(NovelAction action, String topic, AttributionStatus status) {
        DeliveryDeviceInfo ddi = action.getDeliveryDeviceInfo();

        if (Objects.isNull(ddi)) {
            ddi = new DeliveryDeviceInfo();
            String channelStr = String.valueOf(action.getChannelId());
            ddi.setMedia(MediaMapping.getMediaNameByChannelId(channelStr));
            ddi.setAd_plan_id("0");
            ddi.setAd_group_id("0");
            ddi.setAd_creative_id("0");
            ddi.setPlatform_id(String.valueOf(action.getPlatformId()));
            ddi.setDj_channel(channelStr);
        }
        ddi.setOs(action.getClientInfo().getOs());
        ddi.setIs_call(status.id);
        ddi.setDevice_id(action.getDeviceId());
        ddi.setActive_time(System.currentTimeMillis());
        ddi.setChannel(String.valueOf(action.getChannelId()));
        ddi.setUserId(action.getUserId());

        String jsonString = JSONObject.toJSONString(ddi);
        ListenableFuture<SendResult<String, String>> active_result = novelKafkaTemplate.send(topic, jsonString);
        active_result.addCallback(
                result -> VIDEOAPP_SYS_LOG.info("归因成功[{}],归因类型[{}]", jsonString, status.desc),
                ex -> VIDEOAPP_ERROR_LOG.error("归因失败[{}],归因类型[{}]", jsonString, status.desc, ex)
        );
    }

    public <T> T getOldMarket(Class<T> clazz, String key) {
        String value = oldMarketRedisTemplate.opsForValue().get(key);
        if(!Objects.isNull(value)){
            return JSON.parseObject(value,clazz);
        }
        return null;
    }

    public <T> Map<String,T> hgetAllOldMarket(Class<T> clazz,String key) {
        Map<Object, Object> json = oldMarketRedisTemplate.opsForHash().entries(key);

        Map<String, T> map = new HashMap<String, T>();
        for (Map.Entry<Object, Object> item : json.entrySet()) {
            T t = JSON.parseObject(item.getValue().toString(), clazz);
            map.put(item.getKey().toString(), t);
        }
        return map;
    }

    public String getTotalCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId ,int sprDedu, String dateStr) {
        return String.format("%s_total_%d_%d_%d_%s", attributionType, platformId, channelOrPlanId, sprDedu, dateStr);
    }

    public String getCallbackCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId, int sprDedu, String dateStr) {
        return String.format("%s_callback_%d_%d_%d_%s", attributionType, platformId, channelOrPlanId, sprDedu, dateStr);
    }

    public String getFirstCheckerKey(NovelAction action) {
        return Objects.equals(action.getType(), CallBackType.active.getType())
                ? String.format("fc_%s_%d_%s_%s", action.getDeviceId(), action.getPlatformId(),action.getMediaName(),action.getCurrentDateStr())
                : String.format("fc_%s_%d_%s", action.getDeviceId(), action.getPlatformId(),action.getMediaName());
    }

    public int getExpire(NovelAction action) {
        return Objects.equals(action.getType(), CallBackType.active.getType())
                ? 60 * 60 * 24
                : 60 * 60 * 24 * 7;
    }

    public String buildKey(Integer platformId,String deviceId) {
        return String.format("market:activeness:30:%d:%s",platformId,deviceId);
    }


    /******************************************** JDBC *************************************************************/

    @Cached(name="appchannel_video_app", cacheType = CacheType.LOCAL)
    @CacheRefresh(refresh = 300)
    public AppChannelVO getAppChannelByPlatformAndChannel(int platformId,Long channelId) {
        try {
            RowMapper<AppChannelVO> rowMapper = BeanPropertyRowMapper.newInstance(AppChannelVO.class);

            return videoInlandJdbcTemplate.queryForObject(String.format("select id,video_count,mv_count,cpm_count,ecpm_avg_count,motivation_count,arpu_count,ecpm_per_count"
                    + " from app_channel where channel_id=%d and platform_id=%d",channelId,platformId),rowMapper);
        } catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}
