package com.lwby.marketing.att.videoapp.handle;

import cn.hutool.crypto.SecureUtil;
import com.lwby.marketing.att.bystory.CallBackType;
import com.lwby.marketing.att.videoapp.DeviceVideoType;
import com.lwby.marketing.att.videoapp.VideoAppUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.notify.Media;
import com.lwby.marketing.notify.media.Platform;
import com.lwby.marketing.util.DateTimUtils;
import com.lwby.marketing.util.NumberUtils;
import com.lwby.marketing.vo.ClientInfo;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.NovelAction;
import com.lwby.marketing.vo.UserProfile;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

@Slf4j
@Component("videoapp_setup")
public class ParameterSetupVideoAppFlow extends NodeFlow<NovelAction> {
    @Resource
    VideoAppUniversalProcess up;

    private static final Logger VIDEOAPP_ERROR_LOG = LoggerFactory.getLogger("videoapp.error");

    @Override
    public void process(NovelAction action) {
        ClientInfo clientInfo = action.getClientInfo();
        //获取用户注册时间
        UserProfile userProfile = clientInfo.getUser();
        if (userProfile == null || userProfile.getCreateDate() == null) {
            VIDEOAPP_ERROR_LOG.error("ClientInfo.userProfile 对像为[{}],ClientInfo对像[{}]",userProfile, clientInfo);
            action.stop(true);
            return;
        }

        //平台ID
        Integer platformId = clientInfo.getPlatformId();
        //VO对像
        DeliveryDeviceInfo deliveryDeviceInfo = null;
        //设备ID
        String deviceIdKey = null;

        //匹配设备ID
        for(DeviceVideoType type: DeviceVideoType.values()){
            deviceIdKey = type.getDeviceId(clientInfo);
            if(null != deviceIdKey && null != (deliveryDeviceInfo = up.getOldMarket(DeliveryDeviceInfo.class,assembleKey(deviceIdKey,platformId)))){
                clientInfo.setOaid(deliveryDeviceInfo.getOaid());   //回补OAID
                action.setDeliveryDeviceInfo(deliveryDeviceInfo);
                action.setDeviceVideoType(type);
                break;
            }
        }

        action.setPlatformId(platformId);
        action.setUserId(clientInfo.getUser().getId());
        action.setDeviceId(clientInfo.getDID());
        action.setCurrentDateStr(DateTimUtils.getCurrentDateString());

        if (CallBackType.active.getType().equals(action.getType())) {
            action.setChannelId((long)action.getClientInfo().getChannel());
        }


        //非商店吊起参数设置
        if (Objects.nonNull(deliveryDeviceInfo)) {

            action.setChannelId(NumberUtils.parseLong(deliveryDeviceInfo.getDj_channel()));
            action.setPlanId(NumberUtils.parseLong((deliveryDeviceInfo.getAd_plan_id())));
            action.setAdvertiserId(deliveryDeviceInfo.getAdvertiser_id());
            action.setMediaName(deliveryDeviceInfo.getMedia());
            action.setMedia(Media.getMedia(action.getMediaName(), Platform.VIDEO));
        }
    }

    public String assembleKey(String deviceId, int platformId) {
        return String.format("getClickByIdfaAndPlatformId_%s_%d", SecureUtil.md5(deviceId), platformId);
    }
}
