package com.lwby.marketing.att.videoapp.handle;

import com.lwby.marketing.att.bystory.CallBackType;
import com.lwby.marketing.att.videoapp.VideoAppUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.vo.NovelAction;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author songxinyu
 * @version ActiveCallFlow.java, v 0.1 2024年03月04日 18:28 songxinyu Exp $
 */
@Component("videoapp_uploadcall")
public class UploadVideoAppCallFlow extends NodeFlow<NovelAction> {

    @Resource
    VideoAppUniversalProcess up;

    @Override
    public void process(NovelAction action) {
        CallBackType type = CallBackType.getCallBackTypeByType(action.getType());

        boolean success = action.getMedia().notify(action);
        if (success) {
            up.notifyResult(action, type.getTopic()+"_test",type.getStatus());
            up.set(up.getFirstCheckerKey(action), up.getExpire(action), "1");
        }
    }
}
