package com.lwby.marketing.att.videoapp.handle;

import com.lwby.marketing.att.videoapp.VideoAppUniversalProcess;
import com.lwby.marketing.flow.NodeSwitchFlow;
import com.lwby.marketing.util.CacheKeyUtils;
import com.lwby.marketing.vo.AppChannelVO;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.NovelAction;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Objects;

/**
 * @author songxinyu
 * @version VideoAppBehaviorFlow.java, v 0.1 2024年03月25日 15:46 songxinyu Exp $
 */
@Slf4j
@Component("videoapp_behavior")
public class VideoAppBehaviorFlow extends NodeSwitchFlow<NovelAction> {

    private static final Logger VIDEOAPP_SYS_LOG   = LoggerFactory.getLogger("videoapp.sys");

    @Resource
    VideoAppUniversalProcess up;

    @Override
    public boolean checked(NovelAction action) {
        return action.getType() == 3;
    }

    @Override
    public void process(NovelAction action) {

        int platformId = action.getPlatformId();
        Long channelId = action.getChannelId();
        String deviceId = action.getDeviceId();
        long userId = action.getUserId();
        DeliveryDeviceInfo deliveryDeviceInfo = action.getDeliveryDeviceInfo();
        AppChannelVO appChannel = up.getAppChannelByPlatformAndChannel(platformId,channelId);
        Integer ecpmAvgModelCount = null ;
        Integer pecpmModelCount = null;
        Integer motivateModelCount = null ;
        Double arpuModelCount = null ;

        if (Objects.nonNull(appChannel) && ((Objects.nonNull(appChannel.getEcpmAvgCount()) && Objects.nonNull(appChannel.getMotivationCount()))
                || (Objects.nonNull(appChannel.getEcpmPerCount()) && Objects.nonNull(appChannel.getMotivationCount()))
                || (Objects.nonNull(appChannel.getArpuCount()) && Objects.nonNull(appChannel.getMotivationCount())))) {
            if (Objects.nonNull(appChannel.getEcpmAvgCount()) && Objects.nonNull(appChannel.getMotivationCount())) {
                ecpmAvgModelCount = appChannel.getEcpmAvgCount().intValue();
                motivateModelCount = appChannel.getMotivationCount().intValue();
            }
            if (Objects.nonNull(appChannel.getEcpmPerCount()) && Objects.nonNull(appChannel.getMotivationCount())) {
                pecpmModelCount = appChannel.getEcpmPerCount().intValue();
                motivateModelCount = appChannel.getMotivationCount().intValue();
            }
            if (Objects.nonNull(appChannel.getArpuCount()) && Objects.nonNull(appChannel.getMotivationCount())) {
                arpuModelCount = appChannel.getArpuCount();
                motivateModelCount = appChannel.getMotivationCount().intValue();
            }
            VIDEOAPP_SYS_LOG.info("cacheModel in table is set value,djChanel={},deviceId={},userId={},ecpmAvgModelCount={},pecpmModelCount={},motivateModelCount={},arpuModelCount={}",channelId,deviceId,userId,ecpmAvgModelCount,pecpmModelCount,motivateModelCount,arpuModelCount);
        } else {
            VIDEOAPP_SYS_LOG.info("cacheModel in table is not set value,djChanel={},deviceId={},userId={}",channelId,deviceId,userId);
            action.stop(true);
            return;
        }

        // 取缓存算是否触发关键行为
        //总ecpm次数
        Integer tcpmCount = null ;
        //曝光次数
        Integer expCount = null ;
        //平均ecpm次数
        Integer ecpmAvgCount = null ;
        //每次ecpm次数
        Integer pecpmCount = null ;
        //激励视频次数
        Integer motivateCount = null ;
        //激励视频总ecpm次数
        Integer tvcCount = null;
        Double arpuCount = null ;
        String upcBehaviorKey = CacheKeyUtils.getBehavoirKey(userId);
        if (up.exists(upcBehaviorKey)) {
            Map<String, Integer> behaviorMap = up.hgetAllOldMarket(Integer.class, upcBehaviorKey);
            for (Map.Entry<String,Integer> entry : behaviorMap.entrySet()) {
                switch (entry.getKey()) {
                    case "tc": tcpmCount = entry.getValue()/100;break;
                    case "ec": expCount = entry.getValue();break;
                    case "tvc": tvcCount = entry.getValue()/100;break;
                    case "mvc":motivateCount = entry.getValue();break;
                    case "vec":pecpmCount = entry.getValue();break;
                    default: break;
                }
            }
        }

        if (Objects.nonNull(tvcCount) && Objects.nonNull(motivateCount)) {
            if(Objects.nonNull(pecpmCount)) {
                VIDEOAPP_SYS_LOG.info("pecpmcount not null,tcpmCount={},expCount={},arpuCount={},tvcCount={},motivateCount={},pecpmCount={},djChanel={},deviceId={},userId={}",tcpmCount,expCount,arpuCount,tvcCount,motivateCount,pecpmCount,channelId,deviceId,userId);
            }
            Double ecpmAvgCountD = (double)tvcCount / motivateCount;
            ecpmAvgCount = ecpmAvgCountD.intValue();
            arpuCount = (double)tcpmCount / 1000;
            VIDEOAPP_SYS_LOG.info("arpuecpm success,tcpmCount={},expCount={},arpuCount={},tvcCount={},motivateCount={},djChanel={},deviceId={},userId={}",tcpmCount,expCount,arpuCount,tvcCount,motivateCount,channelId,deviceId,userId);
        } else {
            if (Objects.nonNull(tcpmCount) && Objects.nonNull(motivateCount)) {
                arpuCount = (double)tcpmCount / 1000;
                VIDEOAPP_SYS_LOG.info("arpuset success,tcpmCount={},expCount={},arpuCount={},tvcCount={},motivateCount={},djChanel={},deviceId={},userId={}",tcpmCount,expCount,arpuCount,tvcCount,motivateCount,channelId,deviceId,userId);
            } else if (Objects.nonNull(pecpmCount) && Objects.nonNull(motivateCount)) {
                if (Objects.nonNull(tcpmCount)) {
                    arpuCount = (double)tcpmCount / 1000;
                }
                VIDEOAPP_SYS_LOG.info("pempcount and motivate not null,tcpmCount={},expCount={},arpuCount={},tvcCount={},motivateCount={},pecpmCount={},djChanel={},deviceId={},userId={}",tcpmCount,expCount,arpuCount,tvcCount,motivateCount,pecpmCount,channelId,deviceId,userId);
            } else {
                VIDEOAPP_SYS_LOG.info("tvcandmo not up to the standard,tcpmCount={},expCount={},tvcCount={},motivateCount={},djChanel={},deviceId={},userId={}",tcpmCount,expCount,tvcCount,motivateCount,channelId,deviceId,userId);
                action.stop(true);
                return;
            }
        }

        if (Objects.nonNull(motivateModelCount) && Objects.nonNull(motivateCount)) {
            if (motivateCount < motivateModelCount) {
                VIDEOAPP_SYS_LOG.info("motivate not up to the standard,motivateCount={},motivateModelCount={},djChanel={},deviceId={},userId={}",motivateCount,motivateModelCount,channelId,deviceId,userId);
                action.stop(true);
                return;
            }
            deliveryDeviceInfo.setMotivateCount(String.valueOf(motivateCount));
        }

        if (Objects.nonNull(ecpmAvgModelCount) && Objects.nonNull(ecpmAvgCount)) {
            if (Objects.isNull(arpuModelCount)) {
                if ((ecpmAvgCount < ecpmAvgModelCount)) {
                    VIDEOAPP_SYS_LOG.info("ecpm not up to the standard,ecpmAvgCount={},ecpmAvgModelCount={},djChanel={},deviceId={},userId={}",ecpmAvgCount,ecpmAvgModelCount,channelId,deviceId,userId);
                    action.stop(true);
                    return;
                }
                deliveryDeviceInfo.setEcpmAvgCount(String.valueOf(ecpmAvgCount));
            } else {
                //当arpu也配置时，则
                if ((ecpmAvgCount < ecpmAvgModelCount)) {
                    VIDEOAPP_SYS_LOG.info("ecpm and arpu not up to the standard,ecpmAvgCount={},ecpmAvgModelCount={},djChanel={},deviceId={},userId={}",ecpmAvgCount,ecpmAvgModelCount,channelId,deviceId,userId);
                } else {
                    deliveryDeviceInfo.setEcpmAvgCount(String.valueOf(ecpmAvgCount));
                }
            }
        }

        if (Objects.nonNull(pecpmModelCount) && Objects.nonNull(motivateModelCount) && Objects.nonNull(motivateCount)) {
            if (Objects.isNull(arpuModelCount)) {
                if (Objects.nonNull(pecpmCount)) {
                    if (pecpmCount < motivateModelCount) {
                        VIDEOAPP_SYS_LOG.info("pecpmCount not up to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},deviceId={},userId={}",pecpmModelCount,pecpmCount,motivateModelCount,motivateCount,channelId,deviceId,userId);
                        action.stop(true);
                        return;
                    }
                    deliveryDeviceInfo.setPecpmCount(String.valueOf(pecpmModelCount));
                    deliveryDeviceInfo.setPerecpmSize(String.valueOf(pecpmCount));
                    VIDEOAPP_SYS_LOG.info("pecpmCount up to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},deviceId={},userId={}",pecpmModelCount,pecpmCount,motivateModelCount,motivateCount,channelId,deviceId,userId);
                } else {
                    VIDEOAPP_SYS_LOG.info("pecpmCount is null not to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},deviceId={},userId={}",pecpmModelCount,pecpmCount,motivateModelCount,motivateCount,channelId,deviceId,userId);
                    action.stop(true);
                    return;
                }
            } else {
                if (Objects.nonNull(pecpmCount)) {
                    if (pecpmCount < motivateModelCount) {
                        VIDEOAPP_SYS_LOG.info("pecpmCount and arpu not up to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},deviceId={},userId={}",pecpmModelCount,pecpmCount,motivateModelCount,motivateCount,channelId,deviceId,userId);
                    } else {
                        deliveryDeviceInfo.setPecpmCount(String.valueOf(pecpmModelCount));
                        deliveryDeviceInfo.setPerecpmSize(String.valueOf(pecpmCount));
                        VIDEOAPP_SYS_LOG.info("pecpmCount and arpu up to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},deviceId={},userId={}",pecpmModelCount,pecpmCount,motivateModelCount,motivateCount,channelId,deviceId,userId);
                    }
                } else {
                    VIDEOAPP_SYS_LOG.info("pecpmCount and arpu is null not to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},deviceId={},userId={}",pecpmModelCount,pecpmCount,motivateModelCount,motivateCount,channelId,deviceId,userId);
                }
            }


        }
        if (Objects.nonNull(arpuModelCount) && Objects.nonNull(arpuCount)) {
            if (Objects.nonNull(ecpmAvgModelCount)) {
                //配置了 平均ecpm    三个条件    arpu+平均ecpm + 激励视频
                if (Objects.isNull(deliveryDeviceInfo.getEcpmAvgCount())) {
                    // 平均ecpm没达标，看arpu达标没
                    if (arpuCount < arpuModelCount) {
                        VIDEOAPP_SYS_LOG.info("arpu ecpmAvgModelCount not up to the standard,arpuCount={},arpuModelCount={},ecpmAvgCount={},djChanel={},deviceId={},userId={}",arpuCount,arpuModelCount,deliveryDeviceInfo.getEcpmAvgCount(),channelId,deviceId,userId);
                        action.stop(true);
                        return;
                    } else {
                        deliveryDeviceInfo.setEcpmAvgCount(String.valueOf(ecpmAvgCount));
                    }
                }
                VIDEOAPP_SYS_LOG.info("arpu ecpmAvgModelCount up to the standard,arpuCount={},arpuModelCount={},ecpmAvgCount={},djChanel={},deviceId={},userId={}",arpuCount,arpuModelCount,deliveryDeviceInfo.getEcpmAvgCount(),channelId,deviceId,userId);
            } else if (Objects.nonNull(pecpmModelCount)) {
                //配置了 每次ecpm    三个条件    arpu+每次ecpm + 激励视频
                if (Objects.isNull(deliveryDeviceInfo.getPecpmCount())) {
                    // 平均ecpm没达标，看arpu达标没
                    if (arpuCount < arpuModelCount) {
                        VIDEOAPP_SYS_LOG.info("arpu pecpmModelCount not up to the standard,arpuCount={},arpuModelCount={},pecpmCount={},djChanel={},deviceId={},userId={}",arpuCount,arpuModelCount,deliveryDeviceInfo.getPecpmCount(),channelId,deviceId,userId);
                        action.stop(true);
                        return;
                    } else {
                        deliveryDeviceInfo.setPecpmCount(String.valueOf(pecpmModelCount));
                        deliveryDeviceInfo.setPerecpmSize(String.valueOf(pecpmCount));
                    }
                }
                VIDEOAPP_SYS_LOG.info("arpu pecpmModelCount up to the standard,arpuCount={},arpuModelCount={},pecpmCount={},djChanel={},deviceId={},userId={}",arpuCount,arpuModelCount,deliveryDeviceInfo.getPecpmCount(),channelId,deviceId,userId);
            } else {
                //只配两个条件的走原来逻辑  arpu+激励视频
                if (arpuCount < arpuModelCount) {
                    VIDEOAPP_SYS_LOG.info("arpu not up to the standard,arpuCount={},arpuModelCount={},djChanel={},deviceId={},userId={}",arpuCount,arpuModelCount,channelId,deviceId,userId);
                    action.stop(true);
                    return;
                }
            }
            deliveryDeviceInfo.setArpuCount(String.valueOf(arpuCount));
            VIDEOAPP_SYS_LOG.info("arpu up to the standard,arpuCount={},arpuModelCount={},djChanel={},deviceId={},userId={}",arpuCount,arpuModelCount,channelId,deviceId,userId);

        }
    }

}
