package com.lwby.marketing.conf;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;

/**
 * @author songxinyu
 * @version BiRedisConfig.java, v 0.1 2024年03月07日 11:32 songxinyu Exp $
 */
@Configuration
public class BiRedisConfig {

    @Value("${bi.redis.host}")
    private String biHostName;

    @Value("${bi.redis.port}")
    private int biHostPort;

    @Bean("biJedisFactory")
    public JedisConnectionFactory jedisConnectionFactory() {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(biHostName);
        config.setPort(biHostPort);

        return new JedisConnectionFactory(config);
    }

    @Bean("biRedisTemplate")
    public RedisTemplate<Object, Object> redisTemplate(@Qualifier("biJedisFactory") RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<Object, Object> template = new RedisTemplate<>();
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer(stringRedisSerializer);
        template.setValueSerializer(stringRedisSerializer);
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }
}
