package com.lwby.marketing.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alicp.jetcache.anno.CacheRefresh;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.Cached;
import com.lwby.marketing.att.bystory.DyStoryFlowExecutor;
import com.lwby.marketing.att.bystory.DyStoryUniversalProcess;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.po.CrossCallback;
import com.lwby.marketing.util.DateTimUtils;
import com.lwby.marketing.vo.CrossPlatformAccount;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.StoryNovelAction;
import com.lwby.marketing.vo.StoreUserUploadEventBO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author songxinyu
 * @version AttrController.java, v 0.1 2024年03月05日 17:30 songxinyu Exp $
 */

@RestController
@Slf4j
@RequestMapping(value = "/attr")
public class AttrController {

    @Resource
    DyStoryUniversalProcess up;

    @Resource(name = "storyKafka")
    private KafkaTemplate<String, String> storyKafkaTemplate;

    @Resource(name = "novelKafka")
    public KafkaTemplate<String, String> novelKafkaTemplate;

    @Resource
    DyStoryFlowExecutor dyStoryFlowExecutor;

    @RequestMapping("/testUpload")
    public void testUpload() {
        String msg = "{\"clientInfo\":{\"channel\":214120503,\"clientIp\":\"183.219.7.180\",\"pkv\":1,\"platformGroupId\":412,"
                + "\"platformId\":412,\"sessionid\":\"undefined\",\"ua\":\"Mozilla/5.0 (Linux; Android 12; OXF-AN00 Build/HUAWEIOXF-AN00;"
                + " wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/117.0.0.0 Mobile Safari/537.36 aweme.lite/28.9.0 "
                + "ToutiaoMicroApp/3.14.0 PluginVersion/28909073\",\"version\":\"2.0.0\",\"xClient\":\"version=2.0.0;platformId=412;"
                + "equipment=android\"},\"createTime\":1709533439693,\"extraData\":{},\"id\":\"93857260-8130-442f-bc92-b549dbf28ef0\","
                + "\"userId\":875325,\"userUploadEvent\":0,\"appId\":\"ttd3dda5604ce230b401\","
                + "\"openId\":\"_000HgDjWl-P5-WS9HTQIssNgTnMBRUqDHDu\"}";

        StoreUserUploadEventBO event = JSONObject.parseObject(msg, StoreUserUploadEventBO.class);
        StoryNovelAction action = new StoryNovelAction(event.getClientInfo(),event.getUserId(),event.getOpenId(),event.getUserUploadEvent(),
                event.getProductId());

        try {
            dyStoryFlowExecutor.getExecutorByStory().execute(action);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }



    @RequestMapping("dedu")
    public void testDedu() {

        String totalCountKey = up.getTotalCountKey(AttributionType.CHANNEL, 5, 50007L, "1", 50, "2024-03-20");
        System.out.println(totalCountKey);
        Integer platformId = 5;
        Long channelId = 50007L;
        Integer sprDedu = up.getAppChannel(platformId, channelId);
        if (sprDedu == null || sprDedu == 100) {
            System.out.println(sprDedu);
        }
        System.out.println(sprDedu);
        String shaveMakeCall = up.getAttributeRuleByPlatformIdAndChannelId(platformId,channelId);
        if (StringUtils.isEmpty(shaveMakeCall)) {
            //直接回传,走回传流
            return;
        }
        /**
         * 金额扣量规则
         * 商品id  ： 回传
         * {
         *   "1" : 85,
         *   "2" : 90,
         *   "3" : 40,
         *   "4" : 100
         * }
         */

        Map<String, Integer> map = JSON.parseObject(shaveMakeCall, Map.class);

        String goodId = "1";

        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.equals(goodId)) {
                sprDedu = entry.getValue();
                break;
            }
        }

        System.out.println(sprDedu);

//        Function<Integer, IStoryCallback> function = new Function<Integer, IStoryCallback>() {
//            @Override
//            public IStoryCallback apply(Integer c) {
//                return c == 0 ? new JRTTActiveCallback() : new JRTTPayCallback();
//            }
//        };
    }

    @RequestMapping("/send")
    public void testSend() {
        String msg = "{\"clientInfo\":{\"channel\":214120503,\"clientIp\":\"183.219.7.180\",\"pkv\":1,\"platformGroupId\":412,"
                + "\"platformId\":412,\"sessionid\":\"undefined\",\"ua\":\"Mozilla/5.0 (Linux; Android 12; OXF-AN00 Build/HUAWEIOXF-AN00;"
                + " wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/117.0.0.0 Mobile Safari/537.36 aweme.lite/28.9.0 "
                + "ToutiaoMicroApp/3.14.0 PluginVersion/28909073\",\"version\":\"2.0.0\",\"xClient\":\"version=2.0.0;platformId=412;"
                + "equipment=android\"},\"createTime\":1709533439693,\"extraData\":{},\"id\":\"93857260-8130-442f-bc92-b549dbf28ef0\","
                + "\"userId\":875325,\"userUploadEvent\":0,\"appId\":\"ttd3dda5604ce230b401\","
                + "\"openId\":\"_000HgDjWl-P5-WS9HTQIssNgTnMBRUqDHDu\"}";

        StoreUserUploadEventBO event = JSONObject.parseObject(msg, StoreUserUploadEventBO.class);

        storyKafkaTemplate.send("testStoryNovelActive",JSON.toJSONString(event)).addCallback(success -> {
            // 消息发送到的topic
            String topic = success.getRecordMetadata().topic();
            // 消息发送到的分区
            int partition = success.getRecordMetadata().partition();
            // 消息在分区内的offset
            long offset = success.getRecordMetadata().offset();
            log.info("dystory短篇注册发送消息成功: topic={},partition={},offset={}", topic, partition, offset);
        }, failure -> {
            log.error("dystory短篇注册发送消息失败:fail={}", JSON.toJSONString(failure));
        });
    }

    @RequestMapping("/sendPay")
    public void testSendPay() {
        String msg = "{\"clientInfo\":{\"channel\":214120503,\"clientIp\":\"183.219.7.180\",\"pkv\":1,\"platformGroupId\":412,"
                + "\"platformId\":412,\"sessionid\":\"undefined\",\"ua\":\"Mozilla/5.0 (Linux; Android 12; OXF-AN00 Build/HUAWEIOXF-AN00;"
                + " wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/117.0.0.0 Mobile Safari/537.36 aweme.lite/28.9.0 "
                + "ToutiaoMicroApp/3.14.0 PluginVersion/28909073\",\"version\":\"2.0.0\",\"xClient\":\"version=2.0.0;platformId=412;"
                + "equipment=android\"},\"createTime\":1709533439693,\"extraData\":{},\"id\":\"93857260-8130-442f-bc92-b549dbf28ef0\","
                + "\"userId\":875325,\"userUploadEvent\":2,\"productId\":\"1\",\"appId\":\"ttd3dda5604ce230b401\","
                + "\"openId\":\"_000HgDjWl-P5-WS9HTQIssNgTnMBRUqDHDu\"}";

        StoreUserUploadEventBO event = JSONObject.parseObject(msg, StoreUserUploadEventBO.class);

        storyKafkaTemplate.send("testStoryNovelpay",JSON.toJSONString(event)).addCallback(success -> {
            // 消息发送到的topic
            String topic = success.getRecordMetadata().topic();
            // 消息发送到的分区
            int partition = success.getRecordMetadata().partition();
            // 消息在分区内的offset
            long offset = success.getRecordMetadata().offset();
            log.info("dystory短篇付费发送消息成功: topic={},partition={},offset={}", topic, partition, offset);
        }, failure -> {
            log.error("dystory短篇付费发送消息失败:fail={}", JSON.toJSONString(failure));
        });
    }
    @Resource
    JdbcTemplate lwbyJdbcTemplate;
    @Resource
    JdbcTemplate marketingJdbcTemplate;

    public Date getEarliestRegistrationTimeByDeviceId(String deviceId,Integer platformId){
        Date date = lwbyJdbcTemplate.queryForObject(String.format("select max(registration_date) from user_profiles where platform_id != %d and device_id = '%s'",platformId,deviceId),Date.class);
        return Objects.isNull(date)?new Date():date;
    }

    @RequestMapping("testcross")
    public void testCross() {
        DeliveryDeviceInfo deliveryDeviceInfo = new DeliveryDeviceInfo();
        deliveryDeviceInfo.setDevice_id("1231eqw");
        deliveryDeviceInfo.setPlatform_id("6");
        up.set("opt",120,JSON.toJSONString(deliveryDeviceInfo));

        DeliveryDeviceInfo opt = up.get(DeliveryDeviceInfo.class, "opt");


        JSONObject platformPrizeExpireJson = com.alibaba.fastjson2.JSON.parseObject("{\n"
                + "    \"5\": 259200,\n"
                + "    \"6\": 259200,\n"
                + "    \"51\": 259200\n"
                + "}");
        Integer platformPrizeExpireStr = platformPrizeExpireJson.getInteger(String.valueOf(5));

        long daysSinceRegistration = DateTimUtils.calculateDaysBetweenDates(getEarliestRegistrationTimeByDeviceId("56d4428af47940fb",5), new Date());

        //CrossPlatformAccount cpa = getCrossPlatformMedia().get("gdt");
        ////判断是否配置跨平台归因，如果没有则继续执行下一个计划归因处理器
        //if(Objects.isNull(cpa) || (!cpa.getAccount().contains("0") && !cpa.getAccount().contains("32422617"))
        //        || (cpa.getOldAccount().contains("0") || cpa.getOldAccount().contains("32422617"))){
        //    System.out.println(111);
        //}
    }

    @Cached(name="cross_platform_account", cacheType = CacheType.LOCAL)
    @CacheRefresh(refresh = 300)
    public Map<String,CrossPlatformAccount> getCrossPlatformMedia(){

        RowMapper<CrossCallback> rowMapper = BeanPropertyRowMapper.newInstance(CrossCallback.class);
        List<CrossCallback> ls = lwbyJdbcTemplate.query("select span_check_max_day,new_account,old_account,media_name from cross_callback", rowMapper);

        return ls.stream()
                .collect(Collectors.toMap(CrossCallback::getMediaName, CrossPlatformAccount::new));
    }

    @RequestMapping("/sendDyVideo")
    public void testSendDyVideo() {
        String msg = "{\"clientInfo\":{\"channel\":214122006,\"clientIp\":\"125.45.110.52\",\"pkv\":1,\"platformGroupId\":412,"
                + "\"platformId\":412,\"sessionid\":\"undefined\",\"ua\":\"Mozilla/5.0 (Linux; Android 12; PEHM00 Build/SKQ1.210216.001; "
                + "wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/117.0.0.0 Mobile Safari/537.36 aweme.lite/29.2.0 "
                + "ToutiaoMicroApp/3.19.0 PluginVersion/29209076\",\"version\":\"2.0.0\",\"xClient\":\"version=2.0.0;platformId=412;"
                + "equipment=android\"},\"createTime\":1711394346711,\"extraData\":{},\"id\":\"ec792ce2-f448-4daa-b5b9-582e1f1e1bf7\","
                + "\"userId\":913286,\"userUploadEvent\":3,\"wechatAppId\":\"ttd3dda5604ce230b401\","
                + "\"wechatOpenId\":\"_000GI00qFjk0oFW9iYwBmDTC-K257VHXUVL\"}";

        StoreUserUploadEventBO event = JSONObject.parseObject(msg, StoreUserUploadEventBO.class);

        novelKafkaTemplate.send("testDouyinRegisterTopic",JSON.toJSONString(event)).addCallback(success -> {
            // 消息发送到的topic
            String topic = success.getRecordMetadata().topic();
            // 消息发送到的分区
            int partition = success.getRecordMetadata().partition();
            // 消息在分区内的offset
            long offset = success.getRecordMetadata().offset();
            log.info("dyvideo注册发送消息成功: topic={},partition={},offset={}", topic, partition, offset);
        }, failure -> {
            log.error("dyvideo注册发送消息失败:fail={}", JSON.toJSONString(failure));
        });
    }

    @RequestMapping("/sendVideoApp")
    public void testSendVideoapp() {
        com.alibaba.fastjson.JSONObject dyMarketPlatformAppIdJson = JSON.parseObject(
                "{\n"
                        + "    \"400\": \"ttf2f6844b6dc9702901_d4ac08a22f80f73256836fdd9655dbb0b6e6de7c\",\n"
                        + "    \"412\": \"ttd3dda5604ce230b401_5aac82a8c76db9c54f187dea7b43b58b233459db\"\n"
                        + "}");
        String platformKey = String.valueOf(412);
        //走平台
        String dyMarketPlatformAppId = dyMarketPlatformAppIdJson.getString(platformKey);

        String msg = "{\"clientInfo\":{\"channel\":682000,\"clientIp\":\"183.226.74.112\","
                + "\"dID\":\"2705A240-1875-4C38-9529-0343B56B6C49\",\"fixVersion\":4,\"idfa\":\"00000000-0000-0000-0000-000000000000\","
                + "\"language\":\"zh\",\"mainVersion\":1,\"oaid\":\"2705A240-1875-4C38-9529-0343B56B6C49\",\"os\":\"1\","
                + "\"phoneModel\":\"iPhone14,2\",\"pkv\":0,\"platformGroupId\":68,\"platformId\":68,\"pm\":\"iPhone14,2\","
                + "\"screenSize\":\"390*844\",\"subVersion\":0,\"systemVersion\":\"17.3.1\",\"ua\":\"Mozilla/5.0 (iPhone; CPU iPhone OS "
                + "17_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148\","
                + "\"user\":{\"avatarUrl\":\"https://lwby-video-res.oss-accelerate.aliyuncs.com/avatarUrl/1673322782333.png\","
                + "\"createDate\":1711440818292,\"deviceId\":\"2705A240-1875-4C38-9529-0343B56B6C49\",\"goldCoinNum\":0,\"id\":553262,"
                + "\"mainversion\":1,\"nickname\":\"游客545250\",\"platform\":68,\"subversion\":0,\"userStatus\":1},\"version\":\"68.1.0.4"
                + ".682000\",\"xClient\":\"sv=17.3.1;pm=iPhone14,2;ss=390*844;version=68.1.0.4.682000;pkv=0;platformId=68;language=zh;"
                + "dID=2705A240-1875-4C38-9529-0343B56B6C49;idfa=00000000-0000-0000-0000-000000000000;os=1\"},"
                + "\"createTime\":1711440818298,\"extraData\":{},\"id\":\"61e3c546-dee4-4cfb-9430-a50cdc63b732\",\"userUploadEvent\":0}";

        StoreUserUploadEventBO event = JSONObject.parseObject(msg, StoreUserUploadEventBO.class);

        novelKafkaTemplate.send("testFreeVideoEvent",JSON.toJSONString(event)).addCallback(success -> {
            // 消息发送到的topic
            String topic = success.getRecordMetadata().topic();
            // 消息发送到的分区
            int partition = success.getRecordMetadata().partition();
            // 消息在分区内的offset
            long offset = success.getRecordMetadata().offset();
            log.info("dyvideo注册发送消息成功: topic={},partition={},offset={}", topic, partition, offset);
        }, failure -> {
            log.error("dyvideo注册发送消息失败:fail={}", JSON.toJSONString(failure));
        });
    }
}
