package com.lwby.marketing.notify.media.jrtt;

import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.notify.MobileNotify;
import com.lwby.marketing.notify.media.jrtt.dto.JrttAttributeRequest;
import com.lwby.marketing.vo.ClientInfo;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.NovelAction;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class VideoAppJRTTNotify extends MobileNotify {
    public static final String ATTRIBUTE_URL = "https://analytics.oceanengine.com/api/v2/conversion";

    @Override
    public boolean android(NovelAction na) {
        return na.getType() == 0 ? android(na,"active") :android(na,"game_addiction");
    }

    @Override
    public boolean ios(NovelAction na) {
        return na.getType() == 0 ? android(na,"active") :android(na,"game_addiction");
    }

    public boolean android(NovelAction na,String eventType){
        ClientInfo ci = na.getClientInfo();
        DeliveryDeviceInfo ddi = na.getDeliveryDeviceInfo();

        JrttAttributeRequest.Device device = new JrttAttributeRequest.Device();
        device.setPlatform("android");
        device.setImei(ci.getImei());
        device.setOaid(ci.getOaid());

        JrttAttributeRequest.Ad ad = new JrttAttributeRequest.Ad();
        ad.setCallback(ddi.getCallback_param());

        JrttAttributeRequest.Context context = new JrttAttributeRequest.Context();
        context.setAd(ad);
        context.setDevice(device);

        JrttAttributeRequest request = JrttAttributeRequest.builder().context(context).event_type(eventType).timestamp(
                System.currentTimeMillis()).build();

        String userJson = JSONObject.toJSONString(request);
        try {
            //TODO;测试不执行
//            String result = HttpUtil.post(ATTRIBUTE_URL, userJson);
//            Integer resultCode = (Integer) JSON.parseObject(result).get("code");
//            return resultCode == 0;
            log.info("VideoAppJRTTNotify android Callback info:{}",userJson);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public boolean ios(NovelAction na,String eventType) {
        ClientInfo ci = na.getClientInfo();
        DeliveryDeviceInfo ddi = na.getDeliveryDeviceInfo();

        JrttAttributeRequest.Device device = new JrttAttributeRequest.Device();
        device.setPlatform("ios");
        device.setIdfa(ci.getIdfa());

        JrttAttributeRequest.Ad ad = new JrttAttributeRequest.Ad();
        ad.setCallback(ddi.getCallback_param());

        JrttAttributeRequest.Context context = new JrttAttributeRequest.Context();
        context.setAd(ad);
        context.setDevice(device);

        JrttAttributeRequest request = JrttAttributeRequest.builder().context(context).event_type(eventType).timestamp(
                System.currentTimeMillis()).build();

        String userJson = JSONObject.toJSONString(request);
        try {
            //TODO;测试不执行
            //            String result = HttpUtil.post(ATTRIBUTE_URL, userJson);
            //            Integer resultCode = (Integer) JSON.parseObject(result).get("code");
            //            return resultCode == 0;
            log.info("VideoAppJRTTNotify ios Callback info:{}",userJson);
            return true;
        } catch (Exception e) {
            return false;
        }
    }
}
