package com.lwby.marketing.vo;

import com.lwby.marketing.flow.Action;
import com.lwby.marketing.notify.Media;
import com.lwby.marketing.po.StoryLogin;
import com.lwby.marketing.po.VideoUpload;
import lombok.Data;

/**
 * @author songxinyu
 * @version StoreNovelAction.java, v 0.1 2024年03月04日 15:44 songxinyu Exp $
 */
@Data
public class StoryNovelAction extends Action {

    ClientInfo clientInfo;
    //抖音故事会
    StoryLogin storyLogin;
    //抖音短剧
    VideoUpload videoUpload;
    DeliveryDeviceInfo deliveryDeviceInfo;
    String openId;
    int platformId;
    long userId;
    Long channelId;
    Long planId;
    String mediaName;
    Integer    type;
    Media media;
    String     currentDateStr;
    String goodId;


    public StoryNovelAction(ClientInfo clientInfo, Long userId, String openId, Integer type){
        this(clientInfo,null,userId,openId,type);
    }

    public StoryNovelAction(ClientInfo clientInfo, Long userId, String openId, Integer type, String goodId){
        this(clientInfo,null,userId,openId,type,goodId);
    }

    public StoryNovelAction(ClientInfo clientInfo, DeliveryDeviceInfo deliveryDeviceInfo, Long userId, String openId, Integer type){
        this(clientInfo,null,userId,openId,type,null);
    }

    public StoryNovelAction(ClientInfo clientInfo, DeliveryDeviceInfo deliveryDeviceInfo, Long userId, String openId, Integer type, String goodId){
        this.clientInfo = clientInfo;
        this.deliveryDeviceInfo = deliveryDeviceInfo;
        this.userId = userId;
        this.openId = openId;
        this.type = type;
        this.goodId = goodId;
    }



}
