package com.lwby.marketing.att.dyvideo;

import com.lwby.marketing.flow.FlowExecutor;
import com.lwby.marketing.flow.Rule;
import com.lwby.marketing.vo.StoryNovelAction;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

@Component
public class DyVideoFlowExecutor {

    @Resource
    ApplicationContext ctx;
    FlowExecutor<StoryNovelAction> executorByStory;

    @PostConstruct
    public void init(){
        executorByStory = new FlowExecutor<>(ctx, Rule.create().THEN("dyvideo_setup").THEN("dyvideo_store").THEN("dyvideo_checkerfirst").THEN("dyvideo_uploadcall"));
    }

    public FlowExecutor<StoryNovelAction> getExecutorByStory(){
        return this.executorByStory;
    }
}
