package com.lwby.marketing.att.dyvideo.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.BehavoirType;
import com.lwby.marketing.att.CallBackType;
import com.lwby.marketing.att.dyvideo.DyVideoUniversalProcess;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.flow.NodeSwitchFlow;
import com.lwby.marketing.po.ThirdAccountDy;
import com.lwby.marketing.po.VideoUpload;
import com.lwby.marketing.util.CacheKeyUtils;
import com.lwby.marketing.util.HttpUtil;
import com.lwby.marketing.vo.AppChannelVO;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.StoryNovelAction;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.*;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

/**
 * @author songxinyu
 * @version PaySpduFlow.java, v 0.1 2024年03月04日 18:46 songxinyu Exp $
 */
@Slf4j
@Component("dyvideo_behavior")
public class DyvideoBehaviorFlow extends NodeSwitchFlow<StoryNovelAction> {

    private static final Logger DYVIDEO_SYS_LOG   = LoggerFactory.getLogger("dyvideo.sys");

    @Resource
    DyVideoUniversalProcess up;

    @Autowired
    private Environment env;

    private static final String tokenDyDevUrl = "https://open-sandbox.douyin.com/oauth/client_token/";

    private static final String tokenDyProdUrl = "https://open.douyin.com/oauth/client_token/";

    @Override
    public boolean checked(StoryNovelAction action) {
        return action.getType() == 3;
    }

    @Override
    @Async("commonTaskExecutor")
    public void process(StoryNovelAction action) {
        VideoUpload videoUpload = action.getVideoUpload();
        long userId = action.getUserId();
        int platformId = action.getPlatformId();
        Long channelId = action.getChannelId();
        long activeTime = videoUpload.getActiveTime();
        long currentTime = System.currentTimeMillis();
        DeliveryDeviceInfo deliveryDeviceInfo = action.getDeliveryDeviceInfo();
        JSONObject dyMarketPlatformAppIdJson = JSON.parseObject(
                "{\n"
                        + "    \"400\": \"ttf2f6844b6dc9702901_d4ac08a22f80f73256836fdd9655dbb0b6e6de7c\",\n"
                        + "    \"412\": \"ttd3dda5604ce230b401_5aac82a8c76db9c54f187dea7b43b58b233459db\"\n"
                        + "}");
        String platformKey = String.valueOf(platformId);
        //走平台
        String dyMarketPlatformAppId = dyMarketPlatformAppIdJson.getString(platformKey);
        List<String> dyMarketPlatformAppIdList = new ArrayList<>();
        String tokenDy = "";
        ThirdAccountDy thirdAccountDy = null;
        if (dyMarketPlatformAppId != null) {

            dyMarketPlatformAppIdList = Arrays.asList(dyMarketPlatformAppId.split("_"));
            tokenDy = "token_dy_" + dyMarketPlatformAppIdList.get(0);
            DYVIDEO_SYS_LOG.info("thirdAccountDy url={}",
                    Objects.equals(env.getActiveProfiles()[0], "prod") ? tokenDyProdUrl : tokenDyDevUrl);
            if (up.exists(tokenDy)) {
                thirdAccountDy = up.get(ThirdAccountDy.class, tokenDy);
            } else {
                thirdAccountDy = up.getDyAccessToken(dyMarketPlatformAppIdList.get(0), dyMarketPlatformAppIdList.get(1),
                        Objects.equals(env.getActiveProfiles()[0], "prod") ? tokenDyProdUrl : tokenDyDevUrl);
            }
        }

        //这里通过source字段 给乐途上报广告信息
        if (Objects.equals(action.getVideoUpload().getSource(),"lotto")) {
            if (thirdAccountDy != null) {

                LocalDateTime now = LocalDateTime.now(); // 获取当前日期时间
                LocalTime two = LocalTime.of(2, 0, 0); // 获取当天6点的时间
                Date date = new Date();
                JSONArray jsonArray = new JSONArray();
                if (now.toLocalTime().isBefore(two)) {
                    //当天2点之前，查两天,先查昨天的ecpm指标
                    Calendar calendar = Calendar.getInstance(); // 获取日历对象
                    calendar.setTime(date); // 设置时间
                    calendar.add(Calendar.DAY_OF_MONTH, -1); // 将时间减去一天
                    Date day = calendar.getTime();
                    jsonArray = up.getUploadAdsInfo(jsonArray,day,action, thirdAccountDy.getAccessToken(),tokenDy, dyMarketPlatformAppIdList,env);
                }
                jsonArray = up.getUploadAdsInfo(jsonArray,date,action, thirdAccountDy.getAccessToken(),tokenDy, dyMarketPlatformAppIdList,env);

                if (jsonArray.size()>0) {
                    up.uploadCallbackAdsInfo(action,jsonArray.toJSONString());
                }
            }
            return;
        }


        long hour = TimeUnit.MILLISECONDS.toHours(currentTime - activeTime);
        if (hour > 6) {
            DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow expeed six hour ,videoUpload={},userId={}",JSON.toJSONString(videoUpload),userId);
            return;
        }

        AppChannelVO appChannel = up.getAppChannelByPlatformAndChannel(platformId,channelId);

        //处理关键行为上报
        String openId = action.getOpenId();



        if (thirdAccountDy != null) {
            //平均ecpm次数
            Integer ecpmAvgCount = 0;
            //每次ecpm次数
            Integer pecpmCount = 0;
            //激励视频次数
            Integer motivateCount = 0;
            //激励视频总ecpm次数
            Integer tvcCount = 0;

            LocalDateTime now = LocalDateTime.now(); // 获取当前日期时间
            LocalTime six = LocalTime.of(6, 0, 0); // 获取当天6点的时间
            String accessToken = thirdAccountDy.getAccessToken();

            Date date = new Date();
            Map<String, Integer> resultCountMap = null;
            Number behavoirType = BehavoirType.PECPMMODELCOUNT.getBehavoirType(appChannel);
            Integer pecpmModel = null;
            if (behavoirType != null) {
                pecpmModel = behavoirType.intValue();
            }
            if (now.toLocalTime().isBefore(six)) {
                //当天6点之前，查两天,先查昨天的ecpm指标
                Calendar calendar = Calendar.getInstance(); // 获取日历对象
                calendar.setTime(date); // 设置时间
                calendar.add(Calendar.DAY_OF_MONTH, -1); // 将时间减去一天
                Date day = calendar.getTime();
                resultCountMap = up.getResultCountList(day, openId, accessToken, tvcCount, motivateCount, pecpmCount,
                        pecpmModel, userId, tokenDy, dyMarketPlatformAppIdList,env);
                if (resultCountMap != null && resultCountMap.size() != 0) {
                    tvcCount = resultCountMap.get("tvc");
                    if (tvcCount != null) {
                        tvcCount = tvcCount / 100;
                    }
                    motivateCount = resultCountMap.get("motivate");
                    pecpmCount = resultCountMap.get("pecpm");
                }
            }
            //查询今天的ecpm指标
            resultCountMap = up.getResultCountList(date, openId, accessToken, tvcCount, motivateCount, pecpmCount,
                    pecpmModel, userId, tokenDy, dyMarketPlatformAppIdList,env);
            if (resultCountMap != null && resultCountMap.size() != 0) {
                tvcCount = resultCountMap.get("tvc");
                if (tvcCount != null) {
                    tvcCount = tvcCount / 100;
                }
                motivateCount = resultCountMap.get("motivate");
                pecpmCount = resultCountMap.get("pecpm");
            }

            if ((tvcCount != 0 && motivateCount != 0)) {
                Double ecpmAvgCountD = (double)tvcCount / motivateCount;
                ecpmAvgCount = ecpmAvgCountD.intValue();
                DYVIDEO_SYS_LOG.info("ecpmAvgCount success,ecpmAvgCount={},tvcCount={},motivateCount={},djChanel={},userId={}",ecpmAvgCount,tvcCount,motivateCount,channelId,userId);
            } else {
                DYVIDEO_SYS_LOG.info("behavoir not receive data,tvcCount={},motivateCount={},djChanel={},userId={}",tvcCount,motivateCount,channelId,userId);
                action.stop(true);
                return;
            }

            for (BehavoirType type : BehavoirType.values()) {
                Number behavoirVal = type.getBehavoirType(appChannel);
                if (null != behavoirVal && behavoirVal instanceof Integer) {
                    if (type.getValue().startsWith(BehavoirType.MOTIVATEMODELCOUNT.getValue()) && null != motivateCount) {
                        if (motivateCount < behavoirVal.intValue()) {
                            DYVIDEO_SYS_LOG.info("motivate not up to the standard,motivateCount={},motivateModelCount={},djChanel={},userId={}",motivateCount,behavoirVal,channelId,userId);
                            action.stop(true);
                            return;
                        }
                        deliveryDeviceInfo.setMotivateCount(String.valueOf(motivateCount));
                        continue;
                    }
                    if (type.getValue().startsWith(BehavoirType.ECPMAVGMODELCOUNT.getValue()) && null != ecpmAvgCount) {
                        if (ecpmAvgCount < behavoirVal.intValue()) {
                            DYVIDEO_SYS_LOG.info("ecpm not up to the standard,ecpmAvgCount={},ecpmAvgModelCount={},djChanel={},userId={}",ecpmAvgCount,behavoirVal,channelId,userId);
                            action.stop(true);
                            return;
                        }
                        deliveryDeviceInfo.setEcpmAvgCount(String.valueOf(ecpmAvgCount));
                        continue;
                    }
                    if (type.getValue().startsWith(BehavoirType.PECPMMODELCOUNT.getValue()) && null != pecpmCount) {
                        if (pecpmCount < BehavoirType.MOTIVATEMODELCOUNT.getBehavoirType(appChannel).intValue()) {
                            DYVIDEO_SYS_LOG.info("pecpmCount not up to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},userId={}",behavoirVal,pecpmCount,BehavoirType.MOTIVATEMODELCOUNT.getBehavoirType(appChannel),motivateCount,channelId,userId);
                            action.stop(true);
                            return;
                        }

                        deliveryDeviceInfo.setPecpmCount(String.valueOf(behavoirVal));
                        deliveryDeviceInfo.setPerecpmSize(String.valueOf(pecpmCount));
                        break;
                    }
                }
            }

            //满足之后扣量
            Integer sprDedu = appChannel.getSprDedu();

            CallBackType type = CallBackType.getCallBackTypeByType(action.getType());
            //等于空 或 100直接回传
            if (sprDedu == null || sprDedu == 100) {
                action.getMedia().notify(action);
                up.notifyResult(action, type.getTopic(),type.getStatus());
                up.set(up.getFirstCheckerKey(action),up.getExpire(action),"1");
                return;
            }

            //总数
            String channelTotal =  up.getTotalCountKey(AttributionType.CHANNEL, action.getPlatformId(), action.getChannelId(), sprDedu, action.getCurrentDateStr());
            //回传
            String channelCallback = up.getCallbackCountKey(AttributionType.CHANNEL, action.getPlatformId(), action.getChannelId(), sprDedu, action.getCurrentDateStr());

            long channelTotalCount = up.incrby(channelTotal, 0, 60 * 60 * 24);
            long channelCallbackCount = up.incrby(channelCallback, 0, 60 * 60 * 24);

            up.incrby(channelTotal, 1);

            if (isCallback(channelTotalCount, channelCallbackCount, sprDedu)) {
                //回传，回传个数 + 1
                up.incrby(channelCallback, 1);
                action.getMedia().notify(action);
                up.notifyResult(action, type.getTopic(),type.getStatus());
                up.set(up.getFirstCheckerKey(action),up.getExpire(action),"1");
                DYVIDEO_SYS_LOG.info(
                        "ChannelAttributionFlow.process0.deduction doing dynamic, platformId = {}, channel = {}, planId={}, sprDedu = {}, channelTotalCount = {}, channelCallbackCount = {}, v = {}",
                        action.getPlatformId(), action.getChannelId(),action.getPlanId(), sprDedu, channelTotalCount, channelCallbackCount, 1);
            } else {
                up.notifyResult(action,type.getTopic(), AttributionStatus.NORMAL_DEDUCTION_CALLBACK);
                up.set(up.getFirstCheckerKey(action), up.getExpire(action), "1");
                DYVIDEO_SYS_LOG.info(
                        "ChannelAttributionFlow.process0.deduction doing dynamic, platformId = {}, channel = {}, planId={}, sprDedu = {}, channelTotalCount = {}, channelCallbackCount = {}, v = {}",
                        action.getPlatformId(), action.getChannelId(),action.getPlanId(), sprDedu, channelTotalCount, channelCallbackCount, 0);
            }
        }
    }



    private boolean isCallback(long channelTotalCount, long channelCallbackCount, Integer sprDedu) {
        if (channelTotalCount == 0) {
            //首次随机
            return ThreadLocalRandom.current().nextInt(1, 3) == 1;
        }
        //计算回传率
        BigDecimal divide = new BigDecimal(channelCallbackCount).divide(new BigDecimal(channelTotalCount), 4, RoundingMode.HALF_UP);
        //比较回传率和扣量比例，决定是否回传
        double percent = (double) Math.round(sprDedu * 100 / 100.0) / 100;
        return divide.compareTo(BigDecimal.valueOf(percent).setScale(4, RoundingMode.HALF_UP)) != 1;
    }
}
