package com.lwby.marketing.att.dyvideo.handle;

import com.lwby.marketing.att.CallBackType;
import com.lwby.marketing.att.dyvideo.DyVideoUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.notify.Media;
import com.lwby.marketing.notify.media.Platform;
import com.lwby.marketing.po.VideoUpload;
import com.lwby.marketing.util.DateTimUtils;
import com.lwby.marketing.util.NumberUtils;
import com.lwby.marketing.vo.ClientInfo;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.StoryNovelAction;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.UUID;

@Slf4j
@Component("dyvideo_setup")
public class ParameterSetupDyVideoFlow extends NodeFlow<StoryNovelAction> {
    @Resource
    DyVideoUniversalProcess up;

    @Override
    public void process(StoryNovelAction action) {
        ClientInfo clientInfo = action.getClientInfo();
        String openId = action.getOpenId();

        //平台ID
        Integer platformId = clientInfo.getPlatformId();
        //VO对像
        DeliveryDeviceInfo deliveryDeviceInfo = null;

        //String s = "{\"activeTime\":1711439536879,\"adid\":\"7347520002541764646\",\"channel\":\"214122006\",\"clickId\":\"B.1SLXpxqLP8EXNpAqlfUjsQvppp7bkeHT9LpYmfnxMwxH61cZtBGopyXg3glnl8880WYw3XUYfeh21oLLnT9ovSPFtvFp5faNJQbetTFwBfZiesPw0IpoWF2GtLeJW66Bf8vMnUilTWN7sUlexUfVKQiAefYso0MEqhkcUJhpqzz21B\",\"clickTime\":1711394346686,\"code\":\"FN1za8huKsDQ3TyZYhtyzFgjFTDt-ddTEAzYFwrEpYGMyF6NBImpXtzv9ZTZVnoaI6nSyHU4hQ0kjnwNFsXwLV02x0cpIiod-3L9G35DyTOh_K5LQd6Nvs2FQ20\",\"creativeId\":\"1793848259919929\",\"creativeType\":\"15\",\"media\":\"jrtt\",\"videoResourceId\":\"100013\"}";
        //StoryLogin storyLogin = JSONObject.parseObject(s,StoryLogin.class);
        //匹配OpenId
        //VideoUpload videoUpload = JSONObject.parseObject(s,VideoUpload.class);
        VideoUpload videoUpload = up.get(VideoUpload.class,assembleKey(openId));
        action.setVideoUpload(videoUpload);

        //StoryNovelAction对像参数填充
        action.setPlatformId(platformId);
        action.setUserId(action.getUserId());
        action.setCurrentDateStr(DateTimUtils.getCurrentDateString());

        if (CallBackType.active.getType().equals(action.getType())) {
            action.setChannelId((long)action.getClientInfo().getChannel());
        }


        //非商店吊起参数设置
        if (Objects.nonNull(videoUpload)) {
            deliveryDeviceInfo = new DeliveryDeviceInfo();
            deliveryDeviceInfo.setAd_creative_id(videoUpload.getCreativeId());
            deliveryDeviceInfo.setPlatform_id(String.valueOf(clientInfo.getPlatformId()));
            deliveryDeviceInfo.setCallback_param(videoUpload.getClickId());
            deliveryDeviceInfo.setUuid(UUID.randomUUID().toString());
            deliveryDeviceInfo.setDj_channel(videoUpload.getChannel());
            deliveryDeviceInfo.setPromotion_id(videoUpload.getAdid());
            deliveryDeviceInfo.setMedia(videoUpload.getMedia());
            deliveryDeviceInfo.setVideoResourceId(videoUpload.getVideoResourceId());
            action.setDeliveryDeviceInfo(deliveryDeviceInfo);
            action.setChannelId(NumberUtils.parseLong(videoUpload.getChannel()));
            action.setPlanId(NumberUtils.parseLong((videoUpload.getAdid())));
            action.setMediaName(videoUpload.getMedia());
            action.setMedia(Media.getMedia(action.getMediaName(), Platform.DY_VIDEO));
        }
    }

    public String assembleKey(String openId) {
        return String.format("video:upload:%s", openId);
    }
}
