package com.lwby.marketing.att.videoapp;

import com.lwby.marketing.flow.FlowExecutor;
import com.lwby.marketing.flow.Rule;
import com.lwby.marketing.vo.NovelAction;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

@Component
public class VideoAppFlowExecutor {

    @Resource
    ApplicationContext ctx;
    FlowExecutor<NovelAction> executorByStory;

    @PostConstruct
    public void init(){
        executorByStory = new FlowExecutor<>(ctx, Rule.create().THEN("videoapp_setup").THEN("videoapp_store").THEN("videoapp_checkerfirst").SWITCH("videoapp_behavior").THEN("videoapp_uploadcall"));
    }

    public FlowExecutor<NovelAction> getExecutorByStory(){
        return this.executorByStory;
    }
}
