package com.lwby.marketing.conf;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

@Configuration
public class JdbcTemplateConfig {
    @Bean(name = "lwbyJdbcTemplate")
    JdbcTemplate lwbyJdbc(@Qualifier("lwbyDataSource") DataSource dataSource){
        return new JdbcTemplate(dataSource);
    }

    @Bean(name = "marketingJdbcTemplate")
    JdbcTemplate marketingJdbc(@Qualifier("marketingDataSource") DataSource dataSource){
        return new JdbcTemplate(dataSource);
    }

    @Bean(name = "videoJdbcTemplate")
    JdbcTemplate videoJdbc(@Qualifier("videoDataSource") DataSource dataSource){
        return new JdbcTemplate(dataSource);
    }

    @Bean(name = "videoInlandJdbcTemplate")
    JdbcTemplate videoInlandJdbc(@Qualifier("videoInlandDataSource") DataSource dataSource){
        return new JdbcTemplate(dataSource);
    }

}
