package com.lwby.marketing.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.att.dyvideo.DyVideoUniversalProcess;
import com.lwby.marketing.notify.media.jrtt.dto.JrttAttributeRequest;
import com.lwby.marketing.po.DyVideoUpload;
import com.lwby.marketing.po.VideoUpload;
import com.lwby.marketing.util.HttpUtil;
import com.lwby.marketing.util.ResultConstant;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author songxinyu
 * @version DyVideoController.java, v 0.1 2024年04月10日 11:27 songxinyu Exp $
 */
@RestController
@Slf4j
@RequestMapping(value = "/market_attr")
public class DyVideoController {

    public static final String ATTRIBUTE_URL = "https://analytics.oceanengine.com/api/v2/conversion";

    private static final Logger DYVIDEO_SYS_LOG = LoggerFactory.getLogger("dyvideo.sys");

    private static final Logger DYVIDEO_ERROR_LOG = LoggerFactory.getLogger("dyvideo.error");

    @Resource
    DyVideoUniversalProcess up;

    @RequestMapping("uploadBehavoir")
    public String uploadBehavoirByDyVideo(@RequestParam("openId") String openId) {
        Map map  = new HashMap();
        String result = "";
        VideoUpload videoUpload = up.get(VideoUpload.class,assembleKey(openId));
        if (Objects.nonNull(videoUpload)) {
            Integer platformId = videoUpload.getPlatformId();
            String uploadKey = String.format("dv_%s_%d_%s", openId, platformId,videoUpload.getMedia());
            if (up.exists(uploadKey)) {
                map.put("code", ResultConstant.CALL_BACK_UPED_FAIL);
                map.put("message",ResultConstant.CALL_BACK_UPED_MESSAGE);
                result = JSONObject.toJSONString(map);
                DYVIDEO_SYS_LOG.error("DyVideoController uploadBehavoir uped,uploadKey={}",uploadKey);
                return result;
            }

            JrttAttributeRequest.Ad ad = new JrttAttributeRequest.Ad();
            ad.setCallback(videoUpload.getClickId());

            JrttAttributeRequest.Context context = new JrttAttributeRequest.Context();
            context.setAd(ad);

            JrttAttributeRequest request = JrttAttributeRequest.builder().context(context).event_type("game_addiction").timestamp(
                    System.currentTimeMillis()).build();

            String userJson = JSONObject.toJSONString(request);
            try {
                String ret = HttpUtil.post(ATTRIBUTE_URL, userJson);
                Integer resultCode = (Integer) JSON.parseObject(ret).get("code");
                if (resultCode == 0) {
                    map.put("code", ResultConstant.CALL_BACK_SUCCESS);
                    map.put("message",ResultConstant.CALL_BACK_SUCCESS_MESSAGE);
                    result = JSONObject.toJSONString(map) ;
                    //给bi发消息
                    up.notifyResult(openId,videoUpload);
                    up.set(uploadKey,60 * 60 * 24 * 7,"1");

                } else {
                    map.put("code", ResultConstant.CALL_BACK_FAIL);
                    map.put("message",ResultConstant.CALL_BACK_FAIL_MESSAGE);
                    result = JSONObject.toJSONString(map) ;
                    DYVIDEO_SYS_LOG.error("DyVideoController uploadBehavoir send back fail,uploadKey={},code={}",uploadKey,resultCode);
                }
            } catch (Exception e) {
                map.put("code", ResultConstant.CALL_BACK_FAIL);
                map.put("message",ResultConstant.CALL_BACK_FAIL_MESSAGE);
                result = JSONObject.toJSONString(map) ;
                DYVIDEO_ERROR_LOG.error("DyVideoController uploadBehavoir exception,uploadKey={}",uploadKey,e);
                return result;
            }
        } else {
            map.put("code", ResultConstant.CALL_BACK_NOCACHE_FAIL);
            map.put("message",ResultConstant.CALL_BACK_NOCACHE_MESSAGE);
            result = JSONObject.toJSONString(map) ;
            DYVIDEO_SYS_LOG.error("DyVideoController uploadBehavoir no cache,videoUpload={}",JSONObject.toJSONString(videoUpload));
        }
        return result;


    }

    public String assembleKey(String openId) {
        return String.format("video:upload:%s", openId);
    }
}
