package com.lwby.marketing.controller;

import com.alibaba.fastjson.JSON;
import com.lwby.marketing.factory.MediaClickFactory;
import com.lwby.marketing.notify.Media;
import com.lwby.marketing.service.MediaClick;
import com.lwby.marketing.util.Stats;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * @author songxinyu
 * @version MediaClickController.java, v 0.1 2024年04月10日 13:48 songxinyu Exp $
 */
@RestController
@Slf4j
@RequestMapping(value = "/market_growth")
public class MediaClickController {

    @Resource
    MediaClickFactory mediaClickFactory;

    @RequestMapping("/jrtt")
    public Object jrttClick(HttpServletRequest request, HttpServletResponse res){
        Map<String, String> params = new HashMap<String, String>();
        Enumeration<String> en = request.getParameterNames();
        while(en.hasMoreElements()){
            String key = en.nextElement();
            params.put(key, request.getParameter(key));
        }
        log.info("JrttClick params:{}", JSON.toJSONString(params));
        MediaClick mediaClickFacade = mediaClickFactory.getMediaClickFacade(Media.NOVEL_JRTT);
        String result = mediaClickFacade.click("", params);
        log.info("JrttClick , {}",result);
        Stats.HTTP_MG_JRTT.add();
        return result;

    }
}
