package com.lwby.marketing.notify;


import com.lwby.marketing.flow.Action;
import com.lwby.marketing.notify.media.Platform;
import com.lwby.marketing.notify.media.gdt.NovelGDTNotify;
import com.lwby.marketing.notify.media.jrtt.DyVideoJRTTNotify;
import com.lwby.marketing.notify.media.jrtt.NovelJRTTNotify;
import com.lwby.marketing.notify.media.jrtt.StoryJRTTNotify;
import com.lwby.marketing.notify.media.jrtt.VideoAppJRTTNotify;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Media {
    NOVEL_GDT("gdt", Platform.NOVEL, "广点通",new NovelGDTNotify()),
    NOVEL_JRTT("jrtt", Platform.NOVEL, "今日头条",new NovelJRTTNotify()),
    DY_STORY_JRTT("jrtt", Platform.DY_STORY, "今日头条",new StoryJRTTNotify()),
    DY_VIDEO_JRTT("jrtt", Platform.DY_VIDEO, "今日头条",new DyVideoJRTTNotify()),
    VIDEOAPP_JRTT("jrtt_freevideo", Platform.VIDEO, "今日头条",new VideoAppJRTTNotify());

    public final String name;
    final Platform platform;
    final String desc;
    final BaseNotiry baseNotify;

    final static Map<String, Media> mediaMap = Arrays.stream(Media.values())
            .collect(Collectors.toMap(Media::getKey, Function.identity()));

    Media(String name, Platform platform, String desc, BaseNotiry baseNotiry){
        this.name = name;
        this.platform = platform;
        this.desc = desc;
        this.baseNotify = baseNotiry;
    }

    public boolean notify(Action action){
        return baseNotify.delivery(action);
    }

    public static Media getMedia(String mediaName,Platform platform){
        return mediaMap.get(String.format("%s_%s",mediaName,platform.getName()));
    }

    public String getKey(){
        return String.format("%s_%s",this.name,this.platform.getName());
    }
}