package com.lwby.marketing.service.impl;

import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.notify.Media;
import com.lwby.marketing.service.MediaClick;
import com.lwby.marketing.util.CacheKeyUtils;
import com.lwby.marketing.util.ResultConstant;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @author songxinyu
 * @version JrttClickImpl.java, v 0.1 2024年04月10日 14:13 songxinyu Exp $
 */
@Service
@Slf4j
public class JrttClickImpl implements MediaClick {

    /**
     * 今日头条安卓平台标识
     */
    private static final String JRTT_OS_ANDROID = "0";

    /**
     *
     * 今日头条IOS平台标识
     *
     */
    private static final String JRTT_OS_IOS = "1";

    /**
     * 设备信息参数过滤无效信息
     */
    @Value("${click.special.param:00000000-0000-0000-0000-000000000000,9f89c84a559f573636a47ff8daed0d33,__IMEI__,null,'null',NULL,'NULL'}")
    public String specialParamStr;

    @Resource
    private RedisTemplate<String,String> oldMarketRedisTemplate;

    @Resource
    public RedisTemplate<String, String> redisTemplate;

    @Value("${bookIdExpireTime:604800}")
    private int bookIdExpireTime;

    @Resource(name = "storyKafka")
    public KafkaTemplate<String, String> storyKafkaTemplate;

    @Override
    public String click(String s, Map<String, String> params) {
        String uuid = UUID.randomUUID().toString();
        params.put("uuid", uuid);
        params.put("media", "jrtt");
        String result = "";
        String idfa = params.get("idfa");
        String idfaMd5 =  SecureUtil.md5(idfa);
        //idfaMd5 需要转一次小写
        if (StringUtils.isNotEmpty(idfaMd5)) {
            idfaMd5 = idfaMd5.toLowerCase();
        }
        String imeiMd5 = params.get("imei");
        String oaid = params.get("oaid");
        String androidid = params.get("androidid");
        String os = params.get("os");//0–Android; 1–iOS
        String callback_url = params.get("callback_url");
        //头条新增上报字段 - 巨量引擎的关键广告信息
        String callback_param = params.get("callback_param");
        //广告计划id
        String adPlanId = params.get("adid");
        params.put("ad_plan_id", adPlanId);
        //广告创意id
        String adCreativeId = params.get("cid");
        //广告投放位置
        String adSite = params.get("csite");
        //创意样式
        String adType = params.get("ctype");
        //弹窗字段
        String  cpm = params.get("cpm");
        //点击渠道
        String  channel = params.get("channel");
        String platformId = params.get("platform_id");
        String  advertiserId  =params.get("advertiser_id");
        String campaignId = params.get("campaign_id");
        params.put("adgroup_id", campaignId);
        String  ip = params.get("ip");
        String  ua = params.get("ua");
        String model = params.get("model");
        String timeStamp = params.get("TIMESTAMP");
        params.put("click_time", timeStamp);
        String bookId = params.get("book");
        if (StringUtils.isBlank(bookId)) {
            bookId = params.get("books");
            if (StringUtils.isBlank(bookId)) {
                bookId = params.get("book_id");
            }
        }
        String partId = params.get("part_id");
        String adPlatformType = params.get("ad_platform_type");
        String targetAudience = params.get("target_audience");
        //通投智选union_site
        String union_site = params.get("union_site");
        //巨量广告体验版中特有的宏参，代表巨量广告体验版的广告ID
        String promotionId = params.get("promotion_id");
        //巨量广告体验版中特有的宏参，代表巨量广告体验版的项目ID
        String projectId = params.get("project_id");
        //巨量广告体验版中的广告名称
        String promotionName = params.get("promotion_name");
        //巨量广告体验版中的项目名称
        String projectName = params.get("project_name");
        String scheme = params.get("scheme");
        //信息流投放广告来源(碎片 1 书籍 2)
        String source = params.get("source");

        //MatrixLog.build(option).add("MediaClickImpl Monitoring link imei:", imeiMd5).add("oaid", oaid).add("channel", channel).add("bookId",
        //        bookId).add("partId",partId).add("media", MediaEnum.TOU_TIAO.getMediaName()).add("platformId", platformId).info();
        log.info("MediaClickImpl Monitoring link imei:{},oaid:{},channel:{},bookId:{},partId:{},media:{},platformId:{}",imeiMd5,oaid,channel,bookId,partId,Media.NOVEL_JRTT.name,platformId);
        if (ua != null && ua.contains(" Chrome/")) {
            ua = ua.substring(0,ua.indexOf(" Chrome/"));
        }
        String ipAndUaMd5 = SecureUtil.md5(ip + ua);
        String ipMd5 = SecureUtil.md5(ip);

        Map map  = new HashMap();
        List<String> specialParam = Arrays.asList(specialParamStr.split(","));

        if(specialParam.contains(imeiMd5)){
            imeiMd5 = "";
        }
        if(specialParam.contains(oaid)){
            oaid = "";
        }
        if(specialParam.contains(idfa)){
            idfa = "";
        }
        if(StringUtils.isBlank(os)){
            map.put("status", ResultConstant.CALL_BACK_FAIL);
            result = JSONObject.toJSONString(map) ;
            return result;
        }

        //idfa或imei存储的redis key
        String muidKey = StringUtils.EMPTY;
        //oaid存储的redis key
        String oaidKey = StringUtils.EMPTY;
        // ip +ua   redis  key
        String ipAndUaKey = StringUtils.EMPTY;
        String ipKey = StringUtils.EMPTY;
        //获取oaid MD5加密值
        String oaidMd5 = SecureUtil.md5(oaid);
        //0–Android 1–iOS
        if (JRTT_OS_ANDROID.equals(os)) {
            if (StringUtils.isNotEmpty(imeiMd5)) {
                muidKey = CacheKeyUtils.getClickKeyByIdfaAndPlatformId(imeiMd5, platformId);
            }
        } else if (JRTT_OS_IOS.equals(os)) {
            if (StringUtils.isNotEmpty(idfaMd5)) {
                muidKey = CacheKeyUtils.getClickKeyByIdfaAndPlatformId(idfaMd5, platformId);
            }
        }
        //oaid md5不为空 根据点击数据oaid与平台id构造缓存key
        if (StringUtils.isNotEmpty(oaidMd5)) {
            oaidKey = CacheKeyUtils.getClickKeyByIdfaAndPlatformId(oaidMd5, platformId);
        }
        if (StringUtils.isNotEmpty(ip) && StringUtils.isNotEmpty(ua)) {
            ipAndUaKey = CacheKeyUtils.getClickKeyByIdfaAndPlatformId(ipAndUaMd5, platformId);

        }
        if (StringUtils.isNotEmpty(ip)) {
            ipKey = CacheKeyUtils.getClickKey(ipMd5, platformId);
        }

        if("1".equals(os) && StringUtils.isNotEmpty(idfa)){
            if (StringUtils.isNotEmpty(bookId) && StringUtils.isNumeric(bookId)) {
                oldMarketRedisTemplate.opsForValue().set(CacheKeyUtils.getDeliveryBookIdCacheKey(idfa, platformId),JSON.toJSONString(bookId), bookIdExpireTime, TimeUnit.SECONDS);
                redisTemplate.opsForValue().set(CacheKeyUtils.getDeliveryBookIdCacheKey(idfa, platformId),JSON.toJSONString(bookId), bookIdExpireTime, TimeUnit.SECONDS);
            }
            if (StringUtils.isNotEmpty(channel)) {
                oldMarketRedisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(idfaMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);
                redisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(idfaMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);
            }
        }else {
            if (StringUtils.isNotEmpty(oaidMd5)) {
                if (StringUtils.isNotEmpty(channel)) {
                    oldMarketRedisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(oaidMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);
                    redisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(oaidMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);
                }
                if (StringUtils.isNotEmpty(bookId) && StringUtils.isNumeric(bookId)) {
                    oldMarketRedisTemplate.opsForValue().set(CacheKeyUtils.getDeliveryBookIdCacheKey(oaidMd5, platformId),JSON.toJSONString(bookId), bookIdExpireTime, TimeUnit.SECONDS);
                    redisTemplate.opsForValue().set(CacheKeyUtils.getDeliveryBookIdCacheKey(oaidMd5, platformId),JSON.toJSONString(bookId), bookIdExpireTime, TimeUnit.SECONDS);
                }
                if (StringUtils.isNotEmpty(partId) && StringUtils.isNumeric(partId)) {
                    //缓存章节id
                    oldMarketRedisTemplate.opsForValue().set(CacheKeyUtils.getDeliveryPartIdCacheKey(oaidMd5, platformId),JSON.toJSONString(partId), bookIdExpireTime, TimeUnit.SECONDS);
                    redisTemplate.opsForValue().set(CacheKeyUtils.getDeliveryPartIdCacheKey(oaidMd5, platformId),JSON.toJSONString(partId), bookIdExpireTime, TimeUnit.SECONDS);
                }
            }
            if (StringUtils.isNotEmpty(ip) && StringUtils.isNotEmpty(ua)) {
                if (StringUtils.isNotEmpty(channel)) {
                    oldMarketRedisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(ipAndUaMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);
                    redisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(ipAndUaMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);

                    oldMarketRedisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(ipMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);
                    redisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(ipMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);

                }
            }
        }

        storyKafkaTemplate.send("growth_ad_click", JSONObject.toJSONString(params));
        //服务器当前时间
        long now = System.currentTimeMillis();


        DeliveryDeviceInfo deliveryDeviceInfo = new DeliveryDeviceInfo();
        deliveryDeviceInfo.setClick_time(now);
        deliveryDeviceInfo.setAd_group_id(campaignId);
        deliveryDeviceInfo.setAd_creative_id(adCreativeId);
        deliveryDeviceInfo.setAd_plan_id(adPlanId);
        deliveryDeviceInfo.setMedia(Media.NOVEL_JRTT.name);
        deliveryDeviceInfo.setPlatform_id(platformId);
        deliveryDeviceInfo.setDj_channel(channel);
        deliveryDeviceInfo.setBook_id(bookId);
        if (Objects.isNull(callback_param)) {
            deliveryDeviceInfo.setCallback_url(callback_url);
        }
        deliveryDeviceInfo.setAdvertiser_id(advertiserId);
        deliveryDeviceInfo.setUuid(uuid);
        deliveryDeviceInfo.setAd_platform_type(adPlatformType);
        deliveryDeviceInfo.setTarget_audience(targetAudience);
        deliveryDeviceInfo.setUnion_site(union_site);
        deliveryDeviceInfo.setCallback_param(callback_param);
        deliveryDeviceInfo.setIp(ip);
        deliveryDeviceInfo.setPartId(partId);
        if (StringUtils.isNotEmpty(promotionId)) {
            deliveryDeviceInfo.setPromotion_id(promotionId);
        }
        if (StringUtils.isNotEmpty(projectId)) {
            deliveryDeviceInfo.setProject_id(projectId);
        }
        if (StringUtils.isNotEmpty(promotionName)) {
            deliveryDeviceInfo.setPromotion_name(promotionName);
        }
        if (StringUtils.isNotEmpty(projectName)) {
            deliveryDeviceInfo.setProject_name(projectName);
        }
        if (!specialParam.contains(oaid)) {
            deliveryDeviceInfo.setOaid(oaid);
        }
        if (StringUtils.isNotEmpty(imeiMd5)) {
            deliveryDeviceInfo.setImeiMd5(imeiMd5);
        }
        //存储有广告类型区分的用户 传递给业务方
        if (StringUtils.isNotEmpty(source) && StringUtils.isNumeric(source)) {
            deliveryDeviceInfo.setSource(Integer.valueOf(source));
        }
        if (StringUtils.isNotEmpty(model)) {
            try {
                model = URLEncoder.encode(model,"utf-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isEmpty(model) && StringUtils.isNotEmpty(ua)) {
            //Mozilla/5.0 (Linux; Android 11; PDVM00 Build/RKQ1.201217.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0
            model = CacheKeyUtils.getModelByUa(ua);
        }
        if (StringUtils.isNotEmpty(ip) && StringUtils.isNotEmpty(model)) {
            deliveryDeviceInfo.setModel(model);
            String ipAndModelMd5 = SecureUtil.md5(ip + model);
            //Mozilla/5.0 (Linux; Android 11; PDVM00 Build/RKQ1.201217.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0
            if (StringUtils.isNotEmpty(channel)) {
                oldMarketRedisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(ipAndModelMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);
                redisTemplate.opsForValue().set(CacheKeyUtils.getChannelByDeviceIdKeyAndPlatformId(ipAndModelMd5, platformId),JSON.toJSONString(Integer.parseInt(channel)), bookIdExpireTime, TimeUnit.SECONDS);
            }
            //ip + phonemodel
            String ipAndModelKey = CacheKeyUtils.getClickKeyByIdfaAndPlatformId(ipAndModelMd5, platformId);
            oldMarketRedisTemplate.opsForValue().set(ipAndModelKey, JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
            redisTemplate.opsForValue().set(ipAndModelKey, JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
        }

        if (StringUtils.isNotEmpty(muidKey)) {
            oldMarketRedisTemplate.opsForValue().set(muidKey,JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
            redisTemplate.opsForValue().set(muidKey,JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
        }
        if (StringUtils.isNotEmpty(oaidKey)) {
            oldMarketRedisTemplate.opsForValue().set(oaidKey,JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
            redisTemplate.opsForValue().set(oaidKey,JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
        }
        if (StringUtils.isNotEmpty(ipAndUaKey)) {
            oldMarketRedisTemplate.opsForValue().set(ipAndUaKey,JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
            redisTemplate.opsForValue().set(ipAndUaKey,JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
        }
        if (StringUtils.isNotEmpty(ipKey)) {
            oldMarketRedisTemplate.opsForValue().set(ipKey,JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
            redisTemplate.opsForValue().set(ipKey,JSON.toJSONString(deliveryDeviceInfo),bookIdExpireTime, TimeUnit.SECONDS);
        }

        map.put("status", ResultConstant.CALL_BACK_SUCCESS);
        result = JSONObject.toJSONString(map) ;
        return result;
    }


    @Override
    public Media getMedia() {
        return Media.NOVEL_JRTT;
    }
}
