package com.lwby.marketing.util;

import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author songxinyu
 * @version CacheKeyUtils.java, v 0.1 2024年03月22日 17:56 songxinyu Exp $
 */
public class CacheKeyUtils {

    private static final String CACHE_BEHAVIOR_PREFIX = "up_c_";

    static SimpleDateFormat df = new SimpleDateFormat("MMdd");//设置日期格式

    private static final String CACHE_BOOK_PREFIX = "getBookId";

    private static final String CACHE_PART_PREFIX = "getPartId";

    private static final String CHANNEL_PREFIX_KEY = "getChannelBy";


    public static  String getBehavoirKey(Long userId) {
        return CACHE_BEHAVIOR_PREFIX + userId + "_" + df.format(new Date()) + "_fv";
    }

    public static  String getVideoBehavoirKey(Long userId) {
        return CACHE_BEHAVIOR_PREFIX + userId + "_fv";
    }

    public static String getClickKeyByIdfaAndPlatformId(String idfa, String platformId) {
        return "getClickByIdfaAndPlatformId" + "_" + idfa + "_" + platformId;
    }

    public static String getClickKey(String idfa, String platformId) {
        return "mck" + ":" + idfa + ":" + platformId;
    }

    public static String getDeliveryBookIdCacheKey(String deviceKey, String platformId) {
        return CACHE_BOOK_PREFIX + "_" + deviceKey + "_" + platformId;
    }

    public static String getDeliveryPartIdCacheKey(String deviceKey, String platformId) {
        return CACHE_PART_PREFIX + "_" + deviceKey + "_" + platformId;
    }

    public static String getChannelByDeviceIdKeyAndPlatformId(String deviceIdKey, String platformId) {
        return CHANNEL_PREFIX_KEY + deviceIdKey + platformId;
    }

    public static String getModelByUa(String ua) {
        String uasplit = ua.split("Build")[0];
        String model = null;
        try {
            if (ua.startsWith("com.")) {
                String[] split = uasplit.split(";");
                model = split[4].trim();
            } else {
                if (uasplit.split(";").length >= 3 && StringUtils.isNotEmpty(uasplit.split(";")[2].trim())) {
                    model = uasplit.substring(uasplit.lastIndexOf(";") + 2, uasplit.length() - 1);
                    model = URLEncoder.encode(model, "utf-8");
                }
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return model;
    }
}
