package com.lwby.marketing.util;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;

public enum Stats {
    HTTP_MG_JRTT("HTTP接口jrtt", "http_mg_jrtt"),
    HTTP_MG_WECHAT("HTTP接口jrtt", "http_mg_wechat"),
    HTTP_MG_KUAISHOU("HTTP接口jrtt", "http_mg_kuaishou"),
    HTTP_MG_YOUDAO("HTTP接口jrtt", "http_mg_kuaishou"),
    HTTP_MG_XIAOMI("HTTP接口jrtt", "http_mg_xiaomi");

    private String name;
    private Counter counter;
    private String indicator;

    Stats(String name, String indicator) {
        this.name = name;
        this.indicator = indicator;
    }

    public void add() {
        counter.increment();
    }

    public void add(long count) {
        counter.increment(count);
    }

    public String getName() {
        return this.name;
    }

    public long getCount() {
        return (long) counter.count();
    }

    public void bind(MeterRegistry registry) {
        this.counter = registry.counter(indicator);
    }

}