package com.lwby.marketing.att.bystory.handle;

import com.lwby.marketing.att.CallBackType;
import com.lwby.marketing.att.bystory.DyStoryUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.vo.StoryNovelAction;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author songxinyu
 * @version ActiveCallFlow.java, v 0.1 2024年03月04日 18:28 songxinyu Exp $
 */
@Component("dystory_uploadcall")
public class UploadCallFlow extends NodeFlow<StoryNovelAction> {

    @Resource
    DyStoryUniversalProcess up;

    @Override
    public void process(StoryNovelAction action) {
        CallBackType type = CallBackType.getCallBackTypeByType(action.getType());

        boolean success = action.getMedia().notify(action);
        if (success) {
            if (type.getType().equals(CallBackType.active.getType())) {
                up.notifyResult(action, type.getTopic(),type.getStatus());
            } else {
                up.notifyResult(action, Objects.equals(action.getCallbackTypeStory(),3) ? CallBackType.behavior.getTopic() : CallBackType.pay.getTopic(),
                        Objects.equals(action.getCallbackTypeStory(),3) ? CallBackType.behavior.getStatus() : CallBackType.pay.getStatus());
            }
            up.set(up.getFirstCheckerKey(action),60 * 60 * 24,"1");
        }
    }
}
