package com.lwby.marketing.att.dyvideo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.lwby.marketing.flow.FlowExecutor;
import com.lwby.marketing.flow.Rule;
import com.lwby.marketing.vo.StoreUserUploadEventBO;
import com.lwby.marketing.vo.StoryNovelAction;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;

/**
 * @author songxinyu
 * @version DyVideoActiveConsumer.java, v 0.1 2024年03月21日 17:40 songxinyu Exp $
 */
@Slf4j
@Component
public class DyVideoBehavoirConsumer {

    @Resource
    DyVideoFlowExecutor dyVideoFlowExecutor;

    private static final Logger DYVIDEO_SYS_LOG = LoggerFactory.getLogger("dyvideo.sys");

    private static final Logger DYVIDEO_ERROR_LOG = LoggerFactory.getLogger("dyvideo.error");

    @Resource
    ApplicationContext ctx;
    FlowExecutor<StoryNovelAction> executorByDyVideoBehavoir;

    @PostConstruct
    public void init(){
        executorByDyVideoBehavoir = new FlowExecutor<>(ctx, Rule.create().THEN("dyvideo_setup").THEN("dyvideo_store").THEN("dyvideo_checkerfirst").SWITCH("dyvideo_behavior"));
    }

    @KafkaListener(topics = {"${system.consumer.dyvideo.behavoir.topic}"} ,containerFactory = "kafkaListenerContainerFactoryDyVideoBehavoir")
    public void onMessage(List<ConsumerRecord<String, String>> datas) {

        long begin = System.currentTimeMillis();
        if (DYVIDEO_SYS_LOG.isInfoEnabled()) {
            DYVIDEO_SYS_LOG.info("media.behavoir.dyVideo.onMessage start ,size = {}", datas.size());
        }

        for (ConsumerRecord<String, String> data : datas) {
            try {
                if (data == null) {
                    log.warn("media.behavoir.dyVideo.onMessage listen 消费数据为null");
                    return;
                }
                DYVIDEO_SYS_LOG.info("media.behavoir.dyVideo.onMessage start, data={}", data == null ? null : data.value());

                StoreUserUploadEventBO event = JSONObject.parseObject(data.value(), StoreUserUploadEventBO.class);

                DYVIDEO_SYS_LOG.info("media.behavoir.dyVideo.topic={}, bookStoreEvent={}", data.topic(), JSON.toJSONString(event));

                StoryNovelAction action = new StoryNovelAction(event.getClientInfo(), event.getUserId(), event.getWechatOpenId(),
                        event.getUserUploadEvent());

                executorByDyVideoBehavoir.execute(action);
                DYVIDEO_SYS_LOG.info("media.behavoir.dyVideo.end,topic={}, bookStoreEvent={}", data.topic(), JSON.toJSONString(event));
            } catch (Throwable e) {
                DYVIDEO_ERROR_LOG.error("dy.video.behavoir.onMessage failed, data={}, costTime={} ms", data.value(),
                        System.currentTimeMillis() - begin, e);
            }
        }

    }
}
