package com.lwby.marketing.att.dyvideo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alicp.jetcache.anno.CacheRefresh;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.Cached;
import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.UniversalProcess;
import com.lwby.marketing.att.CallBackType;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.po.ThirdAccountDy;
import com.lwby.marketing.util.CacheKeyUtils;
import com.lwby.marketing.util.HttpUtil;
import com.lwby.marketing.vo.AppChannelVO;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.StoryNovelAction;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

@Slf4j
@Component
public class DyVideoUniversalProcess extends UniversalProcess {

    private static final Logger DYVIDEO_SYS_LOG = LoggerFactory.getLogger("dyvideo.sys");

    private static final Logger DYVIDEO_ERROR_LOG = LoggerFactory.getLogger("dyvideo.error");

    @Resource
    private RedisTemplate<String,String> oldMarketRedisTemplate;

    SimpleDateFormat dfh = new SimpleDateFormat("yyyy-MM-dd");//设置日期格式

    private static final String url = "https://open.douyin.com/api/traffic/v1/rt_ecpm/query/";

    private static final String tokenDyDevUrl = "https://open-sandbox.douyin.com/oauth/client_token/";

    private static final String tokenDyProdUrl = "https://open.douyin.com/oauth/client_token/";

    /**
     * 通知处理结果
     */
    public void notifyResult(StoryNovelAction action,String topic, AttributionStatus status) {
        DeliveryDeviceInfo ddi = action.getDeliveryDeviceInfo();

        if (Objects.isNull(ddi)) {
            ddi = new DeliveryDeviceInfo();
            String channelStr = String.valueOf(action.getChannelId());
            ddi.setMedia(MediaMapping.getMediaNameByChannelId(channelStr));
            ddi.setAd_plan_id("0");
            ddi.setAd_group_id("0");
            ddi.setAd_creative_id("0");
            ddi.setPlatform_id(String.valueOf(action.getPlatformId()));
            ddi.setDj_channel(channelStr);
        }

        ddi.setIs_call(status.id);
        ddi.setUserId(action.getUserId());
        ddi.setDevice_id(String.valueOf(action.getUserId()));
        ddi.setActive_time(System.currentTimeMillis());
        ddi.setChannel(String.valueOf(action.getChannelId()));
        ddi.setOpenId(action.getOpenId());

        String jsonString = JSONObject.toJSONString(ddi);
        ListenableFuture<SendResult<String, String>> active_result = storyKafkaTemplate.send(topic, jsonString);
        active_result.addCallback(
                result -> DYVIDEO_SYS_LOG.info("归因成功[{}],归因类型[{}]", jsonString, status.desc),
                ex -> DYVIDEO_ERROR_LOG.error("归因失败[{}],归因类型[{}]", jsonString, status.desc, ex)
        );
    }

    public <T> T getOld(Class<T> clazz, String key) {
        String value = oldMarketRedisTemplate.opsForValue().get(key);
        if(!Objects.isNull(value)){
            return JSON.parseObject(value,clazz);
        }
        return null;
    }

    public void setToken(String key, int expires, String value) {
        oldMarketRedisTemplate.opsForValue().set(key,value,expires, TimeUnit.SECONDS);
    }

    public boolean existsOld(String key) {
        return Boolean.TRUE.equals(oldMarketRedisTemplate.hasKey(key));
    }

    public void delToken(String key) {
        oldMarketRedisTemplate.delete(key);
    }

    public void hsetNew(String key, String field, int expire, String value) {
        oldMarketRedisTemplate.opsForHash().put(key,field,value);
        oldMarketRedisTemplate.expire(key,expire,TimeUnit.SECONDS);
    }


    public String getTotalCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId ,int sprDedu, String dateStr) {
        return String.format("%s_total_%d_%d_%d_%s", attributionType, platformId, channelOrPlanId, sprDedu, dateStr);
    }

    public String getCallbackCountKey(AttributionType attributionType, int platformId, Long channelOrPlanId, int sprDedu, String dateStr) {
        return String.format("%s_callback_%d_%d_%d_%s", attributionType, platformId, channelOrPlanId, sprDedu, dateStr);
    }

    public String getFirstCheckerKey(StoryNovelAction action) {
        return Objects.equals(action.getType(), CallBackType.active.getType())
                ? String.format("fc_%d_%d_%s_%s", action.getUserId(), action.getPlatformId(),action.getMediaName(),action.getCurrentDateStr())
                : String.format("fc_%d_%d_%s", action.getUserId(), action.getPlatformId(),action.getMediaName());
    }

    public int getExpire(StoryNovelAction action) {
        return Objects.equals(action.getType(), CallBackType.active.getType())
                ? 60 * 60 * 24
                : 60 * 60 * 24 * 7;
    }

    public ThirdAccountDy getDyAccessToken(String client_id, String client_secret,String dyTokenUrl) {
        Map<String,String> upMap = new HashMap<>();
        upMap.put("client_key",client_id);
        upMap.put("client_secret",client_secret);
        upMap.put("grant_type","client_credential");
        String mapAction = JSONObject.toJSONString(upMap);
        ThirdAccountDy thirdAccountDy = null;
        try {
            String result = HttpUtil.post(dyTokenUrl, mapAction);
            Map data = (Map) JSON.parseObject(result).get("data");
            Integer resultCode = (Integer) data.get("error_code");
            String accessToken = "";
            if (resultCode == 0) {
                //成功
                accessToken = (String) data.get("access_token");
                Integer expiresIn = (Integer) data.get("expires_in");
                thirdAccountDy = new ThirdAccountDy();
                thirdAccountDy.setAccessToken(accessToken);
                thirdAccountDy.setExpireIn(expiresIn);
                thirdAccountDy.setClientId(client_id);
                String tokenDy = "token_dy_" + client_id;
                //往老的market缓存写，防止token一直失效
                setToken(tokenDy, Integer.parseInt(String.valueOf(expiresIn)),JSON.toJSONString(thirdAccountDy));
            } else {
                log.warn("dy_access_token_error,code={},resultdy={}", resultCode, JSONObject.toJSONString(result));
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }

        return thirdAccountDy;
    }


    /******************************************** JDBC *************************************************************/

    @Cached(name="appchannel_dy_video", cacheType = CacheType.LOCAL)
    @CacheRefresh(refresh = 300)
    public AppChannelVO getAppChannelByPlatformAndChannel(int platformId,Long channelId) {
        try {
            RowMapper<AppChannelVO> rowMapper = BeanPropertyRowMapper.newInstance(AppChannelVO.class);

            return videoJdbcTemplate.queryForObject(String.format("select id,ecpm_avg_count,motivation_count,ecpm_per_count,spr_dedu "
                    + "from app_channel where channel_id=%d and platform_id=%d",channelId,platformId),rowMapper);
        } catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Map<String,Integer> getResultCountList(Date day, String openid, String accessToken, Integer tvcCount, Integer motivateCount, Integer pecpmCount, Integer pecpmModelCount, Long userId, String tokenDy, List<String> dyMarketPlatformAppIdList,
                                                  Environment env) {
        int pageNumer = 1;
        Map<String,Integer> resultCountMap = new HashMap<>();
        String upcBehaviorKey = CacheKeyUtils.getVideoBehavoirKey(userId);

        String cursor = null;

        for (int i=1 ; i<= pageNumer ; i++) {

            Map<String,Object> mp = new HashMap<>();
            mp.put("open_id",openid);
            mp.put("date_hour",dfh.format(day));
            if (cursor != null) {
                mp.put("cursor",cursor);
            }
            String mapAction = JSONObject.toJSONString(mp);
            try {
                String result = HttpUtil.postDy(url, mapAction,accessToken);
                Integer resultCode = (Integer) JSON.parseObject(result).get("err_no");
                if (resultCode == 0) {
                    Map dataMap = (Map) JSON.parseObject(result).get("data");
                    List<JSONObject> records = (List<JSONObject>)dataMap.get("records");
                    String next_cursor = (String)dataMap.get("next_cursor");
                    if (records != null && records.size()>0) {
                        if (Objects.isNull(tvcCount)) {
                            tvcCount = 0;
                        }
                        if (Objects.isNull(motivateCount)) {
                            motivateCount = 0;
                        }
                        if (Objects.isNull(pecpmCount)) {
                            pecpmCount = 0;
                        }
                        motivateCount += records.size();

                        for(JSONObject jsonObject : records) {
                            String cost = jsonObject.getString("cost");
                            Integer costI = Integer.parseInt(cost);
                            Double c =  (double)(costI / 100);
                            int ct = c.intValue();

                            if (pecpmModelCount != null) {
                                if (ct>=pecpmModelCount) {
                                    pecpmCount ++;
                                }
                            }
                            tvcCount +=  costI;

                        }
                        hset(upcBehaviorKey,"tvc",60 * 60 * 24 * 3,JSON.toJSONString(tvcCount));
                        hset(upcBehaviorKey,"mvc",60 * 60 * 24 * 3,JSON.toJSONString(motivateCount));
                        hset(upcBehaviorKey,"vec",60 * 60 * 24 * 3,JSON.toJSONString(pecpmCount));

                    }

                    DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow.douyin code succ,userId={},result={}",userId,JSON.toJSONString(result));
                    if (records != null && records.size() == 500) {
                        pageNumer ++;
                        cursor = next_cursor;
                    }
                } else {
                    DYVIDEO_SYS_LOG.info("DouyinBehaviorKafkaConsumer.douyin code error,userId={},result={}",userId,JSON.toJSONString(result));
                    if (resultCode == 28001008) {
                        //删除授权过期token
                        delToken(tokenDy);
                        getDyAccessToken(dyMarketPlatformAppIdList.get(0), dyMarketPlatformAppIdList.get(1), Objects.equals(env.getActiveProfiles()[0],"prod") ? tokenDyProdUrl : tokenDyDevUrl);
                        DYVIDEO_SYS_LOG.info("DyvideoBehaviorFlow.douyin code auth token expired,userId={},result={}",userId,JSON.toJSONString(result));
                    }
                    return null;
                }
                resultCountMap.put("tvc",tvcCount);
                resultCountMap.put("motivate",motivateCount);
                resultCountMap.put("pecpm",pecpmCount);
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return resultCountMap;
    }

}
