package com.lwby.marketing.conf;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;

@Configuration
public class DataSourceConfig {
    @Bean(name = "lwbyDataSource")
    @Primary
    @ConfigurationProperties("spring.datasource.lwby")
    DataSource lwbyDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name = "marketingDataSource")
    @ConfigurationProperties("spring.datasource.marketing")
    DataSource marketingDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name = "videoDataSource")
    @ConfigurationProperties("spring.datasource.video")
    DataSource videoDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name = "videoInlandDataSource")
    @ConfigurationProperties("spring.datasource.video-inland")
    DataSource videoInlandDataSource() {
        return DataSourceBuilder.create().build();
    }
}
