package com.lwby.marketing.notify.media.jrtt.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author songxinyu
 * @version JrttAttributeRequest.java, v 0.1 2024年02月23日 17:05 songxinyu Exp $
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class JrttAttributeRequest {

    /**
     * {
     *     "event_type": "active",
     *     "context": {
     *         "ad": {
     *             "callback": "EPHk9cX3pv4CGJax4ZENKI7w4MDev_4C",
     *         }
     *     },
     *     "timestamp": 1604888786102
     * }
     */
    /**
     * 回传的事件，例如”激活“、”付费“
     */
    private String event_type;

    /**
     * 包含一些关键的上下文信息
     */
    private Context context;

    /**
     * 事件发生的毫秒级时间戳
     */
    private long timestamp;


    @Data
    public static class Context {

        /**
         * 包含一些关键的广告相关信息
         */
        private Ad ad;

        private Device device;

    }

    @Data
    public static class Ad {

        /**
         * callback 字段有两个获取途径，对于监测链接归因的方式，需要从监测链接的__CALLBACK_PARAM__这个宏获取这个字段值；
         */
        private String callback;
    }

    @Data
    public static class Device {
        /**
         * 设备平台
         */
        private String platform;

        private String imei;

        private String oaid;

        private String idfa;
    }

}
