package com.lwby.marketing.util;

import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;

import java.io.*;

/**
 * @author songxinyu
 * @version HttpUtil.java, v 0.1 2024年03月22日 17:58 songxinyu Exp $
 */
public class HttpUtil {

    public static String post (String url, String toJson) throws IOException {

        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        RequestEntity se = new StringRequestEntity(toJson ,"application/json" ,"UTF-8");
        postMethod.setRequestEntity(se);
        postMethod.setRequestHeader("Content-Type","application/json");
        //默认的重试策略
        postMethod.getParams().setParameter(HttpMethodParams.RETRY_HANDLER, new DefaultHttpMethodRetryHandler());
        postMethod.getParams().setParameter(HttpMethodParams.SO_TIMEOUT, 5000);//设置超时时间
        int httpStatus = httpClient.executeMethod(postMethod);
        InputStream bodystreams = postMethod.getResponseBodyAsStream();
        String body = convertStreamToString(bodystreams);
        return body;
    }

    public static String postDy (String url, String toJson,String token) throws IOException {

        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        RequestEntity se = new StringRequestEntity(toJson ,"application/json" ,"UTF-8");
        postMethod.setRequestEntity(se);
        postMethod.setRequestHeader("Content-Type","application/json");
        postMethod.setRequestHeader("access-token",token);
        //默认的重试策略
        postMethod.getParams().setParameter(HttpMethodParams.RETRY_HANDLER, new DefaultHttpMethodRetryHandler());
        postMethod.getParams().setParameter(HttpMethodParams.SO_TIMEOUT, 5000);//设置超时时间
        int httpStatus = httpClient.executeMethod(postMethod);
        InputStream bodystreams = postMethod.getResponseBodyAsStream();
        String body = convertStreamToString(bodystreams);
        return body;
    }

    public static String convertStreamToString(InputStream is) throws UnsupportedEncodingException {
        //        BufferedReader reader = new BufferedReader(new InputStreamReader(is));//输出的中文乱码
        BufferedReader reader = new BufferedReader(new InputStreamReader(is,"utf8")); //GBK
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}
