package com.lwby.marketing.att.dyvideo.handle;

import com.lwby.marketing.att.CallBackType;
import com.lwby.marketing.att.dyvideo.DyVideoUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.vo.StoryNovelAction;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author songxinyu
 * @version ActiveCallFlow.java, v 0.1 2024年03月04日 18:28 songxinyu Exp $
 */
@Component("dyvideo_uploadcall")
public class UploadDyVideoCallFlow extends NodeFlow<StoryNovelAction> {

    @Resource
    DyVideoUniversalProcess up;

    @Override
    public void process(StoryNovelAction action) {
        CallBackType type = CallBackType.getCallBackTypeByType(action.getType());

        boolean success = action.getMedia().notify(action);
        if (success) {
            //根据source判断是否给指定外包上报
            if (Objects.equals(action.getVideoUpload().getSource(),"lotto")) {
                up.uploadCallbackUserInfo(action);
            }
            action.getVideoUpload().setActiveTime(System.currentTimeMillis());
            up.notifyResult(action, type.getTopic(),type.getStatus());
            up.set(up.getFirstCheckerKey(action),up.getExpire(action),"1");
        }
    }
}
