package com.lwby.marketing.factory;

import com.google.common.collect.ArrayListMultimap;
import com.lwby.marketing.notify.Media;
import com.lwby.marketing.service.MediaClick;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class MediaClickFactory {

    @Autowired
    ApplicationContext applicationContext;


    ArrayListMultimap<Media, MediaClick> multimap = ArrayListMultimap.create();

    /**
     * @return
     */
    /**
     *
     * @return
     */
    public MediaClick getMediaClickFacade(Media mediaEnum) {
        List<MediaClick> mediaClickFacade = multimap.get(mediaEnum);
        return mediaClickFacade.get(0);
    }



    /**
     *
     */
    @PostConstruct
    public void init() {
        Map<String, MediaClick> type = applicationContext.getBeansOfType(MediaClick.class);
        for (Map.Entry<String, MediaClick> item : type.entrySet()) {
            multimap.put(item.getValue().getMedia(), item.getValue());
        }
    }


}
