package com.lwby.marketing.notify.media.jrtt;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.notify.DYNotify;
import com.lwby.marketing.notify.media.jrtt.dto.JrttAttributeRequest;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.StoryNovelAction;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Slf4j
public class DyVideoJRTTNotify extends DYNotify {
    public static final String ATTRIBUTE_URL = "https://analytics.oceanengine.com/api/v2/conversion";

    private static final Logger DYVIDEO_SYS_LOG = LoggerFactory.getLogger("dyvideo.sys");

    @Override
    public boolean active(StoryNovelAction na) {
        return notify(na,"active");
    }

    @Override
    public boolean pay(StoryNovelAction na) {
        return false;
    }

    @Override
    public boolean behavior(StoryNovelAction na) {
        return notify(na,"game_addiction");
    }

    public boolean notify(StoryNovelAction na,String eventType) {
        DeliveryDeviceInfo ddi = na.getDeliveryDeviceInfo();

        JrttAttributeRequest.Ad ad = new JrttAttributeRequest.Ad();
        ad.setCallback(ddi.getCallback_param());

        JrttAttributeRequest.Context context = new JrttAttributeRequest.Context();
        context.setAd(ad);

        JrttAttributeRequest request = JrttAttributeRequest.builder().context(context).event_type(eventType).timestamp(
                System.currentTimeMillis()).build();

        String userJson = JSONObject.toJSONString(request);
        try {
            String result = HttpUtil.post(ATTRIBUTE_URL, userJson);
            Integer resultCode = (Integer) JSON.parseObject(result).get("code");
            DYVIDEO_SYS_LOG.info("DyVideoJRTTNotify.video.{}.upload,userId={},channel={},platform={},code={}",eventType,na.getUserId(),na.getChannelId(),na.getPlatformId(),resultCode);
            return resultCode == 0;
        } catch (Exception e) {
            return false;
        }
    }
}
