package com.lwby.marketing.notify.media.jrtt;

import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.notify.MobileNotify;
import com.lwby.marketing.notify.media.jrtt.dto.JrttAttributeRequest;
import com.lwby.marketing.util.HttpUtil;
import com.lwby.marketing.util.Signature;
import com.lwby.marketing.vo.ClientInfo;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.NovelAction;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;

@Slf4j
public class VideoAppJRTTNotify extends MobileNotify {
    public static final String ATTRIBUTE_URL = "https://analytics.oceanengine.com/api/v2/conversion";

    public static final String uploadAndroidUrl = "https://www.csjplatform.com/growth_dispatcher/api/attribution_callback_self_built/276cbd93-aae4-9b66-68be-b086f7a419d1/android?pg_site_id=5385181&signature=";

    public static final String uploadIosUrl = "https://www.csjplatform.com/growth_dispatcher/api/attribution_callback_self_built/155005fb-6940-4134-8729-f7eb9fb993d6/ios?pg_site_id=5443881&signature=";


    @Override
    public boolean android(NovelAction na) {
        return Objects.equals(na.getType(),0) ? android(na,"active") :android(na,"game_addiction");
    }

    @Override
    public boolean ios(NovelAction na) {
        return Objects.equals(na.getType(),0) ? ios(na,"active") :ios(na,"game_addiction");
    }

    public boolean android(NovelAction na,String eventType){
        ClientInfo ci = na.getClientInfo();
        DeliveryDeviceInfo ddi = na.getDeliveryDeviceInfo();

        JrttAttributeRequest.Device device = new JrttAttributeRequest.Device();
        device.setPlatform("android");
        device.setImei(ci.getImei());
        device.setOaid(ci.getOaid());

        JrttAttributeRequest.Ad ad = new JrttAttributeRequest.Ad();
        ad.setCallback(ddi.getCallback_param());

        JrttAttributeRequest.Context context = new JrttAttributeRequest.Context();
        context.setAd(ad);
        context.setDevice(device);

        JrttAttributeRequest request = JrttAttributeRequest.builder().context(context).event_type(eventType).timestamp(
                System.currentTimeMillis()).build();

        String userJson = JSONObject.toJSONString(request);
        try {
            //TODO;测试不执行
//            String result = HttpUtil.post(ATTRIBUTE_URL, userJson);
//            Integer resultCode = (Integer) JSON.parseObject(result).get("code");
//            return resultCode == 0;
            log.info("VideoAppJRTTNotify android Callback info:{}",userJson);
            //if (Objects.equals(na.getType(),0)) {
            //    sendAutoAttribute(ci,ddi,uploadAndroidUrl);
            //}
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public boolean ios(NovelAction na,String eventType) {
        ClientInfo ci = na.getClientInfo();
        DeliveryDeviceInfo ddi = na.getDeliveryDeviceInfo();

        JrttAttributeRequest.Device device = new JrttAttributeRequest.Device();
        device.setPlatform("ios");
        device.setIdfa(ci.getIdfa());

        JrttAttributeRequest.Ad ad = new JrttAttributeRequest.Ad();
        ad.setCallback(ddi.getCallback_param());

        JrttAttributeRequest.Context context = new JrttAttributeRequest.Context();
        context.setAd(ad);
        context.setDevice(device);

        JrttAttributeRequest request = JrttAttributeRequest.builder().context(context).event_type(eventType).timestamp(
                System.currentTimeMillis()).build();

        String userJson = JSONObject.toJSONString(request);
        try {
            //TODO;测试不执行
            //            String result = HttpUtil.post(ATTRIBUTE_URL, userJson);
            //            Integer resultCode = (Integer) JSON.parseObject(result).get("code");
            //            return resultCode == 0;
            log.info("VideoAppJRTTNotify ios Callback info:{}",userJson);
            //if (Objects.equals(na.getType(),0)) {
            //    sendAutoAttribute(ci,ddi,uploadIosUrl);
            //}
            return true;
        } catch (Exception e) {
            return false;
        }
    }


    private void sendAutoAttribute(ClientInfo clientInfo, DeliveryDeviceInfo deliveryDeviceInfo,String url) {

        try {
            String clientIp = clientInfo.getClientIp();
            String ua = clientInfo.getUa();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("time_ts",System.currentTimeMillis());
            map.put("ad_platform","toutiao_v2");
            if ("0".equals(clientInfo.getOs())) {
                if (StringUtils.isNotEmpty(clientInfo.getImei())) {
                    map.put("imei",clientInfo.getImei());
                    map.put("imei_md5",SecureUtil.md5(clientInfo.getImei()));
                }
                if (StringUtils.isNotEmpty(clientInfo.getOaid())) {
                    map.put("oaid",clientInfo.getOaid());
                    map.put("oaid_md5",SecureUtil.md5(clientInfo.getOaid()));
                }
                if (StringUtils.isNotEmpty(clientInfo.getDID())) {
                    map.put("android_id",clientInfo.getDID());
                    map.put("android_id_md5", SecureUtil.md5(clientInfo.getDID()));
                }
            } else if ("1".equals(clientInfo.getOs())){
                if (StringUtils.isNotEmpty(clientInfo.getIdfa()) && !"00000000-0000-0000-0000-000000000000".equals(clientInfo.getIdfa())) {
                    map.put("idfa",clientInfo.getIdfa());
                    map.put("idfa_md5",SecureUtil.md5(clientInfo.getIdfa()));
                } else {
                    map.put("idfa",clientInfo.getDID());
                    map.put("idfa_md5",SecureUtil.md5(clientInfo.getDID()));
                }
                if (StringUtils.isNotEmpty(clientIp) && StringUtils.isNotEmpty(ua)) {
                    map.put("ip",clientIp);
                    map.put("ua",ua);
                }
            }

            map.put("ad_id",deliveryDeviceInfo.getPromotion_id());
            map.put("ad_name",deliveryDeviceInfo.getPromotion_name());
            map.put("campaign_id",deliveryDeviceInfo.getProject_id());
            map.put("campaign_name",deliveryDeviceInfo.getProject_name());
            map.put("ad_account_id",deliveryDeviceInfo.getAdvertiser_id());
            if (StringUtils.isNotBlank(deliveryDeviceInfo.getMid1())) {
                map.put("mid1",deliveryDeviceInfo.getMid1());
            }
            if (StringUtils.isNotBlank(deliveryDeviceInfo.getMid2())) {
                map.put("mid2",deliveryDeviceInfo.getMid2());
            }
            if (StringUtils.isNotBlank(deliveryDeviceInfo.getMid3())) {
                map.put("mid3",deliveryDeviceInfo.getMid3());
            }
            if (StringUtils.isNotBlank(deliveryDeviceInfo.getMid4())) {
                map.put("mid4",deliveryDeviceInfo.getMid4());
            }
            if (StringUtils.isNotBlank(deliveryDeviceInfo.getMid5())) {
                map.put("mid5",deliveryDeviceInfo.getMid5());
            }
            if (StringUtils.isNotBlank(deliveryDeviceInfo.getMid6())) {
                map.put("mid6",deliveryDeviceInfo.getMid6());
            }

            String signature = Signature.getSignature(map);
            String mapAction = JSONObject.toJSONString(map);

            try {
                String result = HttpUtil.post(url+signature, mapAction);
                JSONObject bresp = (JSONObject) JSON.parseObject(result).get("base_resp");
                Integer resultCode = (Integer) bresp.get("status");

                if (resultCode == 0) {
                    log.info("JrttFreeVideoActiveImpl.sendAutoAttribute success, clientInfo = {}, deliveryDeviceInfo = {}",
                            JSON.toJSONString(clientInfo),JSON.toJSONString(deliveryDeviceInfo));
                } else {
                    log.info("JrttFreeVideoActiveImpl.sendAutoAttribute fail, result={}, clientInfo = {} , deliveryDeviceInfo = {}",
                            result,JSON.toJSONString(clientInfo),JSON.toJSONString(deliveryDeviceInfo));
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        } catch (Throwable e) {
            log.info("JrttFreeVideoActiveImpl.sendAutoAttribute error,clientInfo={}",JSON.toJSONString(clientInfo),e);
        }

    }
}
