package com.lwby.marketing.util;

import org.apache.commons.lang3.time.FastDateFormat;

import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateTimUtils {
    public static final FastDateFormat DATE_TIME_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss", TimeZone.getTimeZone(ZoneId.of("Asia/Shanghai")));

    public static final FastDateFormat DATE_BOTTOM_FORMAT = FastDateFormat.getInstance("yyyy_MM_dd", TimeZone.getTimeZone(ZoneId.of("Asia/Shanghai")));

    /**
     * 是否为当天时间
     *
     * @param date1
     * @return
     */
    public static boolean isCurrentDayTime(Date date1) {
        Date date2 = new Date();
        return date1.getYear() == date2.getYear() && date1.getMonth() == date2.getMonth() && date1.getDate() == date2.getDate();
    }


    public static String getCurrentDateString(){
        return DATE_BOTTOM_FORMAT.format(new Date());
    }

    public static String getCurrentTimeString(){
        return DATE_TIME_FORMAT.format(new Date());
    }

    public static String getCurrentTimeString(Date date){
        return DATE_TIME_FORMAT.format(date);
    }

    /**
     * 时间是否大于7天
     *
     * @param date
     * @return
     */
    public static boolean isTimeGreaterThanSevenDays(Date date) {
        return isTimeGreaterThanDays(date,7);
    }


    /**
     * 时间是否大于指定天数
     *
     * @param date
     * @return
     */
    public static boolean isTimeGreaterThanDays(Date date,long day) {
        return date.before(new Date(System.currentTimeMillis() - 60 * 60 * 24 * day * 1000));
    }

    /**
     * 计算日期区间天数
     * @return
     */
    public static long calculateDaysBetweenDates(Date startDate, Date endDate) {
        return TimeUnit.DAYS.convert(Math.abs(endDate.getTime() - startDate.getTime()), TimeUnit.MILLISECONDS);
    }

    /**
     * 计算指定的时间，是否在给定最小最大天数据区间
     * @param registrationDate
     * @param minDays
     * @param maxDays
     * @return
     */
    public static boolean isWithinDaysRange(Date registrationDate, int minDays, int maxDays) {
        long daysSinceRegistration = calculateDaysBetweenDates(registrationDate, new Date());
        return daysSinceRegistration >= minDays && daysSinceRegistration <= maxDays;
    }

}
