package com.lwby.marketing.vo;

import com.lwby.marketing.po.CrossCallback;
import lombok.Data;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

@Data
public class CrossPlatformAccount {
    /**
     * 媒体名称
     */
    private String mediaName;

    /**
     * 跨包纯新用户最大配置天数
     */
    private Integer spanCheckMaxDay;
    /**
     * 跨平台帐号
     */
    private Set<String> account;

    private Set<String> oldAccount;

    public CrossPlatformAccount(CrossCallback ccb){
        setMediaName(ccb.getMediaName());
        setSpanCheckMaxDay(ccb.getSpanCheckMaxDay());
        setAccount(Arrays.stream(ccb.getNewAccount().split(","))
                .map(String::trim)
                .filter(_s -> _s.matches("\\d+"))
                .collect(Collectors.toSet()));
        setOldAccount(Arrays.stream(ccb.getOldAccount().split(","))
                .map(String::trim)
                .filter(_s -> _s.matches("\\d+"))
                .collect(Collectors.toSet()));
    }
}
