package com.lwby.marketing.att;

import com.lwby.marketing.vo.AppChannelVO;

import java.util.Objects;
import java.util.function.Function;

public enum BehavoirType {
    MOTIVATEMODELCOUNT("motivateModelCount",(a) -> Objects.nonNull(a.getMotivationCount()) ? a.getMotivationCount().intValue() : null),
    ECPMAVGMODELCOUNT("ecpmAvgModelCount", (a) -> Objects.nonNull(a.getEcpmAvgCount()) ? a.getEcpmAvgCount().intValue() : null),
    PECPMMODELCOUNT("pecpmModelCount",(a) -> Objects.nonNull(a.getEcpmPerCount()) ? a.getEcpmPerCount().intValue() : null),
    ARPUMODELCOUNT("arpuModelCount",(a) -> Objects.nonNull(a.getArpuCount()) ? a.getArpuCount().doubleValue() : null);

    private String value;

    private Function<AppChannelVO,Number> fun;

    BehavoirType(String value, Function<AppChannelVO,Number> fun) {
        this.value = value;
        this.fun = fun;
    }

    public String getValue() {
        return this.value;
    }

    public Number getBehavoirType(AppChannelVO appChannel){
        return fun.apply(appChannel);
    }

}