package com.lwby.marketing.att.videoapp;

import com.alibaba.fastjson.JSON;
import com.lwby.marketing.flow.FlowExecutor;
import com.lwby.marketing.flow.Rule;
import com.lwby.marketing.vo.BookStoreEvent;
import com.lwby.marketing.vo.NovelAction;
import com.lwby.marketing.vo.StoreUserUploadEventBO;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;

/**
 * @author songxinyu
 * @version VideoAppActiveConsumer.java, v 0.1 2024年03月25日 17:40 songxinyu Exp $
 */
@Slf4j
@Component
public class VideoAppBehavoirConsumer {

    @Resource
    VideoAppFlowExecutor videoAppFlowExecutor;

    private static final Logger VIDEO_SYS_LOG = LoggerFactory.getLogger("videoapp.sys");

    private static final Logger VIDEO_ERROR_LOG = LoggerFactory.getLogger("videoapp.error");

    @KafkaListener(topics = {"${system.consumer.videoapp.behavoir.topic}"} ,containerFactory = "kafkaListenerContainerFactoryVideoappBehavoir")
    public void onMessage(List<ConsumerRecord<String, String>> datas) {

        long begin = System.currentTimeMillis();
        if (VIDEO_SYS_LOG.isInfoEnabled()) {
            VIDEO_SYS_LOG.info("media.behavoir.onMessage start ,size = {}", datas.size());
        }


        for (ConsumerRecord<String, String> data : datas) {
            try {
                if (data == null) {
                    VIDEO_SYS_LOG.warn("media.behavoir.story.onMessage listen 消费数据为null");
                    return;
                }

                VIDEO_SYS_LOG.info("media.behavoir.onMessage start, data={}", data == null ? null : data.value());

                StoreUserUploadEventBO event = JSON.parseObject(data.value(), StoreUserUploadEventBO.class);
                VIDEO_SYS_LOG.info("media.behavoir.topic={}, bookStoreEvent={}", data.topic(), JSON.toJSONString(event));

                NovelAction action = new NovelAction(event.getClientInfo(), data.value(),event.getUserUploadEvent());

                videoAppFlowExecutor.getExecutorByStory().execute(action);
            } catch (Throwable e) {
                VIDEO_ERROR_LOG.info("media.behavoir.onMessage failed, data={}, costTime={} ms", data.value(),
                        System.currentTimeMillis() - begin, e);
            }
        }

    }
}