package com.lwby.marketing.att.videoapp.handle;

import com.lwby.marketing.att.BehavoirType;
import com.lwby.marketing.att.videoapp.VideoAppUniversalProcess;
import com.lwby.marketing.flow.NodeSwitchFlow;
import com.lwby.marketing.util.CacheKeyUtils;
import com.lwby.marketing.vo.AppChannelVO;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.NovelAction;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Objects;

/**
 * @author songxinyu
 * @version VideoAppBehaviorFlow.java, v 0.1 2024年03月25日 15:46 songxinyu Exp $
 */
@Slf4j
@Component("videoapp_behavior")
public class VideoAppBehaviorFlow extends NodeSwitchFlow<NovelAction> {

    private static final Logger VIDEOAPP_SYS_LOG   = LoggerFactory.getLogger("videoapp.sys");

    @Resource
    VideoAppUniversalProcess up;

    @Override
    public boolean checked(NovelAction action) {
        return action.getType() == 3;
    }

    @Override
    public void process(NovelAction action) {

        int platformId = action.getPlatformId();
        Long channelId = action.getChannelId();
        String deviceId = action.getDeviceId();
        long userId = action.getUserId();
        DeliveryDeviceInfo deliveryDeviceInfo = action.getDeliveryDeviceInfo();
        AppChannelVO appChannel = up.getAppChannelByPlatformAndChannel(platformId,channelId);
        if (Objects.isNull(appChannel)) {
            VIDEOAPP_SYS_LOG.info("cacheModel in table is not set value,djChanel={},deviceId={},userId={}",channelId,deviceId,userId);
            action.stop(true);
            return;
        }
        // 取缓存算是否触发关键行为
        //平均ecpm次数
        Integer ecpmAvgCount = 0 ;
        //每次ecpm次数
        Integer pecpmCount = 0 ;
        //激励视频次数
        Integer motivateCount = 0 ;
        //激励视频总ecpm次数
        Integer tvcCount = 0;
        Double arpuCount = 0.0 ;
        String upcBehaviorKey = CacheKeyUtils.getBehavoirKey(userId);
        if (up.existsOld(upcBehaviorKey)) {
            Map<String, Integer> behaviorMap = up.hgetAllOldMarket(Integer.class, upcBehaviorKey);
            for (Map.Entry<String,Integer> entry : behaviorMap.entrySet()) {
                switch (entry.getKey()) {
                    case "tc": arpuCount = (double)entry.getValue()/100000;break;
                    case "tvc": tvcCount = entry.getValue()/100;break;
                    case "mvc":motivateCount = entry.getValue();break;
                    case "vec":pecpmCount = entry.getValue();break;
                    default: break;
                }
            }
        }

        if ((tvcCount != 0 && motivateCount != 0)) {
            Double ecpmAvgCountD = (double)tvcCount / motivateCount;
            ecpmAvgCount = ecpmAvgCountD.intValue();
            VIDEOAPP_SYS_LOG.info("ecpmAvgCount success,ecpmAvgCount={},arpucount={},tvcCount={},motivateCount={},djChanel={},deviceId={},userId={}",ecpmAvgCount,arpuCount,tvcCount,motivateCount,channelId,deviceId,userId);
        } else {
            VIDEOAPP_SYS_LOG.info("behavoir not receive data,tvcCount={},motivateCount={},djChanel={},deviceId={},userId={}",tvcCount,motivateCount,channelId,deviceId,userId);
            action.stop(true);
            return;
        }

        int conditionNum = 0;
        for (BehavoirType type : BehavoirType.values()) {
            Number behavoirVal = type.getBehavoirType(appChannel);
            if (null != behavoirVal) {
                conditionNum ++;
            }
        }
        for (BehavoirType type : BehavoirType.values()) {
            Number behavoirVal = type.getBehavoirType(appChannel);
            if (null != behavoirVal && behavoirVal instanceof Integer) {
                if (type.getValue().startsWith(BehavoirType.MOTIVATEMODELCOUNT.getValue()) && null != motivateCount) {
                    if (motivateCount < behavoirVal.intValue()) {
                        VIDEOAPP_SYS_LOG.info("motivate not up to the standard,motivateCount={},motivateModelCount={},djChanel={},deviceId={},userId={},conditionNum={}",motivateCount,behavoirVal,channelId,deviceId,userId,conditionNum);
                        action.stop(true);
                        break;
                    }
                    deliveryDeviceInfo.setMotivateCount(String.valueOf(motivateCount));
                    continue;
                }
                if (type.getValue().startsWith(BehavoirType.ECPMAVGMODELCOUNT.getValue()) && null != ecpmAvgCount) {
                    if (ecpmAvgCount < behavoirVal.intValue()) {
                        VIDEOAPP_SYS_LOG.info("ecpm not up to the standard,ecpmAvgCount={},ecpmAvgModelCount={},djChanel={},deviceId={},userId={},conditionNum={}",ecpmAvgCount,behavoirVal,channelId,deviceId,userId,conditionNum);
                        if (Objects.equals(conditionNum,3)) {
                            continue;
                        }
                        action.stop(true);
                        break;
                    }
                    deliveryDeviceInfo.setEcpmAvgCount(String.valueOf(ecpmAvgCount));
                    if (Objects.equals(conditionNum,3)) {
                        break;
                    }
                    continue;
                }
                if (type.getValue().startsWith(BehavoirType.PECPMMODELCOUNT.getValue()) && null != pecpmCount) {
                    if (pecpmCount < BehavoirType.MOTIVATEMODELCOUNT.getBehavoirType(appChannel).intValue()) {
                        VIDEOAPP_SYS_LOG.info("pecpmCount not up to the standard,pecpmModelCount={},pecpmCount={},motivateModelCount={},motivateCount={},djChanel={},deviceId={},userId={},conditionNum={}",behavoirVal,pecpmCount,BehavoirType.MOTIVATEMODELCOUNT.getBehavoirType(appChannel),motivateCount,channelId,deviceId,userId,conditionNum);
                        if (Objects.equals(conditionNum,3)) {
                            continue;
                        }
                        action.stop(true);
                        break;
                    }

                    deliveryDeviceInfo.setPecpmCount(String.valueOf(behavoirVal));
                    deliveryDeviceInfo.setPerecpmSize(String.valueOf(pecpmCount));
                    if (Objects.equals(conditionNum,3)) {
                        break;
                    }
                    continue;
                }
            } else if (null != behavoirVal && behavoirVal instanceof Double) {
                if (type.getValue().startsWith(BehavoirType.ARPUMODELCOUNT.getValue()) && null != arpuCount) {
                    if (arpuCount < behavoirVal.doubleValue()) {
                        VIDEOAPP_SYS_LOG.info("arpu ecpmAvgModelCount not up to the standard,arpuCount={},arpuModelCount={},ecpmAvgCount={},djChanel={},deviceId={},userId={},conditionNum={}",arpuCount,behavoirVal,deliveryDeviceInfo.getEcpmAvgCount(),channelId,deviceId,userId,conditionNum);
                        action.stop(true);
                        break;
                    }
                    deliveryDeviceInfo.setArpuCount(String.valueOf(arpuCount));
                }
            }
        }

    }
}
