package com.lwby.marketing.att;

import com.alibaba.fastjson.JSON;
import com.alicp.jetcache.anno.CacheRefresh;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.Cached;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Slf4j
@Component
public class UniversalProcess {
    @Resource
    public JdbcTemplate lwbyJdbcTemplate;

    @Resource(name = "novelKafka")
    public KafkaTemplate<String, String> novelKafkaTemplate;

    @Resource
    public RedisTemplate<String, String> redisTemplate;

    @Resource
    public RedisTemplate<String,String> biRedisTemplate;


    /******************************************** REDIS **********************************************************/

    public boolean existsIsAlive(String key) {
        return Boolean.TRUE.equals(biRedisTemplate.hasKey(key));
    }

    public boolean exists(String key) {
        return Boolean.TRUE.equals(redisTemplate.hasKey(key));
    }

    public void set(String key, int expires, String value) {
        redisTemplate.opsForValue().set(key,value,expires, TimeUnit.SECONDS);
    }

    public <T> T get(Class<T> clazz, String key) {
        String value = redisTemplate.opsForValue().get(key);
        if(!Objects.isNull(value)){
            return JSON.parseObject(value,clazz);
        }
        return null;
    }

    public long incrby(String key, int increment, int expireSecond) {
        Long v = redisTemplate.opsForValue().increment(key,increment);
        redisTemplate.expire(key,expireSecond, TimeUnit.SECONDS);
        return Objects.isNull(v)?0: v;
    }

    public long incrby(String key, int increment) {
        return redisTemplate.opsForValue().increment(key,increment);
    }


    /******************************************** INNER CLASS ******************************************************/

    /**
     * 媒体ID和名称关系映射
     */
    public static class MediaMapping{
        static Map<String, String> mediaMap = ImmutableMap.<String, String>builder()
                .put("11", "xiaomi")
                .put("12", "huawei")
                .put("13", "oppo")
                .put("14", "vivo")
                .put("15", "yingyongbao")
                .put("16", "meizu")
                .put("17", "360zhushou")
                .put("18", "baiduzhushou")
                .put("19", "other")
                .put("21", "jinritoutiao")
                .put("22", "guangdiantong")
                .put("23", "kuaishou")
                .put("24", "uc")
                .put("25", "qutoutiao")
                .put("28", "youdao")
                .put("33", "dystore")
                .build();

        public static String getMediaNameByChannelId(String channelId){
            return mediaMap.get(channelId.substring(0, 2));
        }
    }


    /******************************************** JDBC *************************************************************/
    @Cached(name="appchannel_novel", cacheType = CacheType.LOCAL)
    @CacheRefresh(refresh = 300)
    public Integer getAppChannel(int platformId, Long channelId){
        try {
            return lwbyJdbcTemplate.queryForObject(String.format("select spr_dedu from app_channel where platform_id=%d and channel_id=%s ORDER BY update_time DESC LIMIT 1",platformId,String.valueOf(channelId)),Integer.class);
        } catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}