package com.lwby.marketing.att.bystory;

import com.lwby.marketing.att.AttributionStatus;

/**
 * @author songxinyu
 * @version CallBackType.java, v 0.1 2024年03月06日 17:32 songxinyu Exp $
 */
public enum CallBackType {

    active(0,"ocpc_result", AttributionStatus.ACTIVE_CALLBACK),pay(2,"ocpc_pay",AttributionStatus.PAY);

    private Integer type;

    private String topic;

    private AttributionStatus status;

    private CallBackType(Integer type,String topic,AttributionStatus status) {
        this.type = type;
        this.topic = topic;
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public AttributionStatus getStatus() {
        return status;
    }

    public void setStatus(AttributionStatus status) {
        this.status = status;
    }

    public static CallBackType getCallBackTypeByType(Integer type) {
        for (CallBackType callBackType:CallBackType.values()) {
            if (callBackType.getType().equals(type)) {
                return callBackType;
            }
        }
        return null;
    }
}
